/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropTable
extends SqlDrop {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP TABLE", SqlKind.DROP_TABLE);
    private SqlIdentifier tableName;
    private boolean ifExists;
    private final boolean isTemporary;

    public SqlDropTable(SqlParserPos pos, SqlIdentifier tableName, boolean ifExists, boolean isTemporary) {
        super(OPERATOR, pos, ifExists);
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.isTemporary = isTemporary;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableName);
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public void setTableName(SqlIdentifier viewName) {
        this.tableName = viewName;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        if (this.isTemporary) {
            writer.keyword("TEMPORARY");
        }
        writer.keyword("TABLE");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.tableName.unparse(writer, leftPrec, rightPrec);
    }

    public String[] fullTableName() {
        return this.tableName.names.toArray(new String[0]);
    }
}

