/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;

@Internal
class InConverter
extends CustomizedConverter {
    InConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        InConverter.checkArgument(call, call.getChildren().size() > 1);
        Expression headExpr = (Expression)call.getChildren().get(1);
        if (headExpr instanceof TableReferenceExpression) {
            QueryOperation tableOperation = ((TableReferenceExpression)headExpr).getQueryOperation();
            RexNode child = context.toRexNode((Expression)call.getChildren().get(0));
            return RexSubQuery.in(((FlinkRelBuilder)context.getRelBuilder()).queryOperation(tableOperation).build(), ImmutableList.of(child));
        }
        List<RexNode> child = ExpressionConverter.toRexNodes(context, call.getChildren());
        return context.getRelBuilder().getRexBuilder().makeIn(child.get(0), child.subList(1, child.size()));
    }
}

