/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.Objects;
import org.apache.flink.annotation.Internal;

@Internal
public class CastCodeBlock {
    private final String code;
    private final String returnTerm;
    private final String isNullTerm;

    private CastCodeBlock(String code, String returnTerm, String isNullTerm) {
        this.code = code;
        this.returnTerm = returnTerm;
        this.isNullTerm = isNullTerm;
    }

    public static CastCodeBlock withoutCode(String returnTerm, String isNullTerm) {
        return new CastCodeBlock("", returnTerm, isNullTerm);
    }

    public static CastCodeBlock withCode(String code, String returnTerm, String isNullTerm) {
        return new CastCodeBlock(code, returnTerm, isNullTerm);
    }

    public String getCode() {
        return this.code;
    }

    public String getReturnTerm() {
        return this.returnTerm;
    }

    public String getIsNullTerm() {
        return this.isNullTerm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CastCodeBlock that = (CastCodeBlock)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.returnTerm, that.returnTerm) && Objects.equals(this.isNullTerm, that.isNullTerm);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.returnTerm, this.isNullTerm);
    }
}

