/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class DecimalToDecimalCastRule
extends AbstractExpressionCodeGeneratorCastRule<DecimalData, DecimalData> {
    static final DecimalToDecimalCastRule INSTANCE = new DecimalToDecimalCastRule();

    private DecimalToDecimalCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.DECIMAL).target(LogicalTypeRoot.DECIMAL).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        DecimalType targetDecimalType = (DecimalType)targetLogicalType;
        return CastRuleUtils.staticCall(BuiltInMethods.DECIMAL_TO_DECIMAL(), inputTerm, targetDecimalType.getPrecision(), targetDecimalType.getScale());
    }
}

