/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.runtime.groupwindow.WindowReference;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
final class LogicalWindowJsonDeserializer
extends StdDeserializer<LogicalWindow> {
    private static final long serialVersionUID = 1L;

    LogicalWindowJsonDeserializer() {
        super(LogicalWindow.class);
    }

    public LogicalWindow deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        String kind = jsonNode.get("kind").asText().toUpperCase();
        WindowReference alias = (WindowReference)deserializationContext.readValue(jsonNode.get("alias").traverse(jsonParser.getCodec()), WindowReference.class);
        FieldReferenceExpression timeField = this.deserializeFieldReferenceExpression(jsonNode.get("timeField"), jsonParser, deserializationContext);
        switch (kind) {
            case "TUMBLING": {
                boolean isTimeTumblingWindow = jsonNode.get("isTimeWindow").asBoolean();
                if (isTimeTumblingWindow) {
                    Duration size = (Duration)deserializationContext.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.get("size"), jsonParser.getCodec()), Duration.class);
                    return new TumblingGroupWindow(alias, timeField, new ValueLiteralExpression((Object)size));
                }
                long size = jsonNode.get("size").asLong();
                return new TumblingGroupWindow(alias, timeField, new ValueLiteralExpression((Object)size));
            }
            case "SLIDING": {
                boolean isTimeSlidingWindow = jsonNode.get("isTimeWindow").asBoolean();
                if (isTimeSlidingWindow) {
                    Duration size = (Duration)deserializationContext.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.get("size"), jsonParser.getCodec()), Duration.class);
                    Duration slide = (Duration)deserializationContext.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.get("slide"), jsonParser.getCodec()), Duration.class);
                    return new SlidingGroupWindow(alias, timeField, new ValueLiteralExpression((Object)size), new ValueLiteralExpression((Object)slide));
                }
                long size = jsonNode.get("size").asLong();
                long slide = jsonNode.get("slide").asLong();
                return new SlidingGroupWindow(alias, timeField, new ValueLiteralExpression((Object)size), new ValueLiteralExpression((Object)slide));
            }
            case "SESSION": {
                Duration gap = (Duration)deserializationContext.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.get("gap"), jsonParser.getCodec()), Duration.class);
                return new SessionGroupWindow(alias, timeField, new ValueLiteralExpression((Object)gap));
            }
        }
        throw new TableException("Unknown Logical Window:" + jsonNode);
    }

    private FieldReferenceExpression deserializeFieldReferenceExpression(JsonNode input, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String name = input.get("fieldName").asText();
        int fieldIndex = input.get("fieldIndex").asInt();
        int inputIndex = input.get("inputIndex").asInt();
        LogicalType type = (LogicalType)deserializationContext.readValue(input.get("fieldType").traverse(jsonParser.getCodec()), LogicalType.class);
        return new FieldReferenceExpression(name, (DataType)new AtomicDataType(type), inputIndex, fieldIndex);
    }
}

