/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint;

import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.Priority;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

@GBean
@Priority(priority=2)
public class WaitForBlueprintGBean {
    private volatile BlueprintEvent event;
    private CountDownLatch latch = new CountDownLatch(1);

    public WaitForBlueprintGBean(@ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamAttribute(name="packageName") String packageName, @ParamAttribute(name="symbolicName") String symbolicName) throws Exception {
        final Bundle bundle = BundleUtils.unwrapBundle((Bundle)this.getBundle(bundleContext, symbolicName, packageName));
        BlueprintListener listener = new BlueprintListener(){

            public void blueprintEvent(BlueprintEvent event) {
                if (event.getBundle() == bundle && (event.getType() == 2 || event.getType() == 5)) {
                    WaitForBlueprintGBean.this.event = event;
                    WaitForBlueprintGBean.this.latch.countDown();
                }
            }
        };
        ServiceRegistration registration = bundleContext.registerService(BlueprintListener.class.getName(), (Object)listener, new Hashtable());
        this.latch.await();
        registration.unregister();
        if (this.event.getType() == 5) {
            throw new Exception("Could not start blueprint plan", this.event.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle getBundle(BundleContext bundleContext, String symbolicName, String packageName) throws Exception {
        ServiceReference reference = bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(reference);
        try {
            if (symbolicName != null) {
                Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
                if (bundles == null) {
                    throw new Exception("Unable to find bundle based on symbolic name. There is no bundle with " + symbolicName + " symbolic name");
                }
                if (bundles.length > 1) {
                    throw new Exception("Found multiple bundles with the same symbolic name: " + symbolicName);
                }
                Bundle bundle = bundles[0];
                return bundle;
            }
            if (packageName != null) {
                ExportedPackage exportedPackage = packageAdmin.getExportedPackage(packageName);
                if (exportedPackage == null) {
                    throw new Exception("Unable to find bundle based on package name. There is no bundle that exports " + packageName + " package");
                }
                Bundle bundle = exportedPackage.getExportingBundle();
                return bundle;
            }
            Bundle bundle = bundleContext.getBundle();
            return bundle;
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }
}

