/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common.propertyeditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.common.propertyeditor.PropertiesEditor;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;
import org.apache.geronimo.crypto.EncryptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEditor
extends TextPropertyEditorSupport {
    private static final Logger log = LoggerFactory.getLogger(MapEditor.class);

    @Override
    public void setAsText(String text) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(text == null ? new byte[]{} : text.getBytes());
            Properties p = new Properties();
            p.load(is);
            Iterator<Object> it = p.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (!key.toLowerCase().endsWith("password")) continue;
                String encryptedValue = (String)p.get(key);
                String decryptedValue = (String)((Object)EncryptionManager.decrypt((String)encryptedValue));
                p.put(key, decryptedValue);
            }
            this.setValue(p);
        }
        catch (IOException e) {
            throw new PropertyEditorException(e.getMessage(), e);
        }
    }

    @Override
    public String getAsText() {
        Map map = (Map)this.getValue();
        if (!(map instanceof Properties)) {
            Properties p = new Properties();
            if (map != null) {
                if (!map.containsKey(null) && !map.containsValue(null)) {
                    p.putAll((Map<?, ?>)map);
                } else {
                    log.warn("Map contains null keys or values.  Replacing null values with empty string.");
                    for (Map.Entry entry : map.entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (key == null) {
                            key = "";
                        }
                        if (value == null) {
                            value = "";
                        }
                        p.put(key, value);
                    }
                }
                Iterator<Object> it = p.keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    if (!key.toLowerCase().endsWith("password")) continue;
                    String value = (String)p.get(key);
                    String encryptedValue = EncryptionManager.encrypt((Serializable)((Object)value));
                    p.put(key, encryptedValue);
                }
                map = p;
            }
        }
        PropertiesEditor pe = new PropertiesEditor();
        pe.setValue(map);
        return pe.getAsText();
    }
}

