/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.util.Stack;
import org.apache.geronimo.kernel.repository.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingDependencyException
extends Exception {
    private static final long serialVersionUID = -2557777157677213124L;
    private Artifact query;
    private Stack<Artifact> stack;

    public MissingDependencyException(Artifact query) {
        this.query = query;
    }

    public MissingDependencyException(Artifact query, Stack<Artifact> stack) {
        this.query = query;
        this.stack = stack;
    }

    public MissingDependencyException(Artifact query, Artifact parent) {
        this.query = query;
        this.stack = new Stack();
        if (parent != null) {
            this.stack.add(parent);
        }
    }

    public MissingDependencyException(String message, Artifact query, Stack<Artifact> stack) {
        super(message);
        this.query = query;
        this.stack = stack;
    }

    public MissingDependencyException(String message, Artifact query, Artifact parent) {
        super(message);
        this.query = query;
        this.stack = new Stack();
        if (parent != null) {
            this.stack.add(parent);
        }
    }

    @Override
    public String getMessage() {
        String s = super.getMessage();
        StringBuffer sb = new StringBuffer();
        if (s != null) {
            sb.append(s).append("\n");
        }
        if (this.query != null) {
            sb.append("Missing dependency: ").append(this.query);
        }
        if (this.stack != null && !this.stack.isEmpty()) {
            sb.append("\nParent stack:\n");
            for (Artifact parent : this.stack) {
                sb.append("    ").append(parent).append("\n");
            }
        }
        return sb.toString();
    }

    public Artifact getQuery() {
        return this.query;
    }

    public void setQuery(Artifact query) {
        this.query = query;
    }

    public Stack<Artifact> getStack() {
        return this.stack;
    }

    public void setStack(Stack<Artifact> stack) {
        this.stack = stack;
    }
}

