/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.FileUtils;

public class ConfigurationResolver {
    private final Artifact configurationId;
    private final ArtifactResolver artifactResolver;
    private final Collection<? extends Repository> repositories;
    private final File baseDir;
    private final ConfigurationStore configurationStore;
    private final String moduleName;

    public ConfigurationResolver(Artifact configurationId, File baseDir) {
        if (configurationId == null) {
            throw new NullPointerException("configurationId is null");
        }
        this.configurationId = configurationId;
        this.baseDir = baseDir;
        this.artifactResolver = null;
        this.repositories = Collections.emptySet();
        this.configurationStore = null;
        this.moduleName = null;
    }

    public ConfigurationResolver(ConfigurationData configurationData, Collection<? extends Repository> repositories, ArtifactResolver artifactResolver) {
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        if (repositories == null) {
            repositories = Collections.emptySet();
        }
        for (Repository repository : repositories) {
            if (repository != null) continue;
            throw new NullPointerException("null repository");
        }
        this.configurationId = configurationData.getId();
        this.artifactResolver = artifactResolver;
        this.repositories = repositories;
        this.configurationStore = configurationData.getConfigurationStore();
        this.baseDir = null != configurationData.getInPlaceConfigurationDir() ? configurationData.getInPlaceConfigurationDir() : configurationData.getConfigurationDir();
        this.moduleName = null;
    }

    private ConfigurationResolver(Artifact configurationId, ArtifactResolver artifactResolver, Collection<? extends Repository> repositories, File baseDir, ConfigurationStore configurationStore, String moduleName) {
        this.configurationId = configurationId;
        this.artifactResolver = artifactResolver;
        this.repositories = repositories;
        this.baseDir = baseDir;
        this.configurationStore = configurationStore;
        this.moduleName = moduleName;
    }

    public ConfigurationResolver createChildResolver(String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException("moduleName is null");
        }
        if (this.moduleName != null) {
            moduleName = this.moduleName + '/' + moduleName;
        }
        File childBaseDir = null;
        if (this.baseDir != null) {
            childBaseDir = new File(this.baseDir, moduleName);
        }
        return new ConfigurationResolver(this.configurationId, this.artifactResolver, this.repositories, childBaseDir, this.configurationStore, moduleName);
    }

    public File resolve(Artifact artifact) throws MissingDependencyException {
        for (Repository repository : this.repositories) {
            if (!repository.contains(artifact)) continue;
            File file = repository.getLocation(artifact);
            return file;
        }
        throw new MissingDependencyException(artifact);
    }

    public Set<URL> resolve(String pattern) throws MalformedURLException, NoSuchConfigException {
        if (this.configurationStore != null) {
            Set<URL> matches = this.configurationStore.resolve(this.configurationId, this.moduleName, pattern);
            return matches;
        }
        if (this.baseDir != null) {
            Set<URL> matches = FileUtils.search(this.baseDir, pattern);
            return matches;
        }
        throw new IllegalStateException("No configurationStore or baseDir supplied so paths can not be resolved");
    }

    public List<Dependency> resolveTransitiveDependencies(Collection<Configuration> parents, List<Dependency> dependencies) throws MissingDependencyException {
        Stack<Artifact> parentStack = new Stack<Artifact>();
        return this.internalResolveTransitiveDependencies(parents, dependencies, parentStack);
    }

    private List<Dependency> internalResolveTransitiveDependencies(Collection<Configuration> parents, List<Dependency> dependencies, Stack<Artifact> parentStack) throws MissingDependencyException {
        ArrayList<Dependency> resolvedDependencies = new ArrayList<Dependency>();
        for (Dependency dependency1 : dependencies) {
            Dependency dependency = this.resolveDependency(parents, dependency1, parentStack);
            if (resolvedDependencies.contains(dependency)) continue;
            resolvedDependencies.add(dependency);
        }
        return resolvedDependencies;
    }

    private Dependency resolveDependency(Collection<Configuration> parents, Dependency dependency, Stack<Artifact> parentStack) throws MissingDependencyException {
        Artifact artifact = dependency.getArtifact();
        if (this.artifactResolver == null) {
            if (artifact.isResolved()) {
                return dependency;
            }
            throw new MissingDependencyException("Artifact is not resolved and there no artifact resolver available: ", artifact, parentStack);
        }
        try {
            artifact = this.artifactResolver.resolveInClassLoader(artifact, parents);
        }
        catch (MissingDependencyException e) {
            e.setQuery(artifact);
            e.setStack(parentStack);
            throw e;
        }
        Dependency resolvedDependency = new Dependency(artifact, dependency.getImportType());
        return resolvedDependency;
    }
}

