/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.lang.reflect.Method;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanInfoFactoryException;
import org.osgi.framework.Bundle;

public class BasicGBeanInfoFactory
implements GBeanInfoFactory {
    @Override
    public GBeanInfo getGBeanInfo(Class clazz) throws GBeanInfoFactoryException {
        Method method;
        try {
            method = clazz.getDeclaredMethod("getGBeanInfo", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                clazz = clazz.getClassLoader().loadClass(clazz.getName() + "GBean");
                method = clazz.getDeclaredMethod("getGBeanInfo", new Class[0]);
            }
            catch (Exception ignored) {
                throw new GBeanInfoFactoryException("Class does not have a getGBeanInfo() method: " + clazz.getName());
            }
        }
        catch (NoClassDefFoundError e) {
            String message = e.getMessage();
            StringBuilder buf = new StringBuilder("Could not load gbean class ").append(clazz.getName()).append(" due to NoClassDefFoundError\n");
            if (message != null) {
                message = message.replace('/', '.');
                buf.append("    problematic class ").append(message);
                try {
                    Class<?> hardToLoad = clazz.getClassLoader().loadClass(message);
                    buf.append(" can be loaded in supplied classloader ").append(clazz.getClassLoader()).append("\n");
                    buf.append("    and is found in ").append(hardToLoad.getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    buf.append(" cannot be loaded in supplied classloader ").append(clazz.getClassLoader()).append("\n");
                }
            }
            throw new GBeanInfoFactoryException(buf.toString(), e);
        }
        try {
            return (GBeanInfo)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new GBeanInfoFactoryException("Could not get GBeanInfo from class: " + clazz.getName(), e);
        }
        catch (NoClassDefFoundError e) {
            throw new GBeanInfoFactoryException("Could not get GBeanInfo from class: " + clazz.getName(), e);
        }
    }

    @Override
    public GBeanInfo getGBeanInfo(String className, Bundle bundle) throws GBeanInfoFactoryException {
        Method method;
        Class clazz;
        try {
            clazz = bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new GBeanInfoFactoryException("Could not load class " + className, e);
        }
        catch (NoClassDefFoundError e) {
            throw new GBeanInfoFactoryException("Could not load class " + className, e);
        }
        try {
            method = clazz.getDeclaredMethod("getGBeanInfo", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                clazz = bundle.loadClass(className + "GBean");
                method = clazz.getDeclaredMethod("getGBeanInfo", new Class[0]);
            }
            catch (Exception ignored) {
                throw new GBeanInfoFactoryException("Class does not have a getGBeanInfo() method: " + className);
            }
        }
        catch (NoClassDefFoundError e) {
            String message = e.getMessage();
            StringBuilder buf = new StringBuilder("Could not load gbean class ").append(className).append(" due to NoClassDefFoundError\n");
            if (message != null) {
                message = message.replace('/', '.');
                buf.append("    problematic class ").append(message);
                try {
                    Class hardToLoad = bundle.loadClass(message);
                    buf.append(" can be loaded in supplied classloader ").append(bundle).append("\n");
                    buf.append("    and is found in ").append(hardToLoad.getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    buf.append(" cannot be loaded in supplied classloader ").append(bundle).append("\n");
                }
            }
            throw new GBeanInfoFactoryException(buf.toString(), e);
        }
        try {
            return (GBeanInfo)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new GBeanInfoFactoryException("Could not get GBeanInfo from class: " + className, e);
        }
        catch (NoClassDefFoundError e) {
            throw new GBeanInfoFactoryException("Could not get GBeanInfo from class: " + className, e);
        }
    }
}

