/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.ObjectInputStreamExt;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Environment;
import org.osgi.framework.Bundle;

public class SerializedGBeanState
implements GBeanState,
Serializable {
    private static final long serialVersionUID = 6015138334529564307L;
    private final List<GBeanData> gbeans = new ArrayList<GBeanData>();
    private byte[] gbeanState;

    public SerializedGBeanState(Collection<GBeanData> gbeans) {
        if (gbeans != null) {
            this.gbeans.addAll(gbeans);
        }
    }

    @Override
    public List<GBeanData> getGBeans(Bundle bundle) throws InvalidConfigException {
        if (this.gbeanState == null) {
            return Collections.unmodifiableList(this.gbeans);
        }
        this.gbeans.addAll(SerializedGBeanState.loadGBeans(this.gbeanState, bundle));
        return Collections.unmodifiableList(this.gbeans);
    }

    @Override
    public void addGBean(GBeanData gbeanData) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        this.gbeans.add(gbeanData);
    }

    @Override
    public GBeanData addGBean(String name, GBeanInfo gbeanInfo, Naming naming, Environment environment) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        String j2eeType = gbeanInfo.getJ2eeType();
        if (j2eeType == null) {
            j2eeType = "GBean";
        }
        AbstractName abstractName = naming.createRootName(environment.getConfigId(), name, j2eeType);
        GBeanData gBeanData = new GBeanData(abstractName, gbeanInfo);
        this.addGBean(gBeanData);
        return gBeanData;
    }

    @Override
    public GBeanData addGBean(String name, Class gbeanClass, Naming naming, Environment environment) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        GBeanData gBeanData = new GBeanData(gbeanClass);
        String j2eeType = gBeanData.getGBeanInfo().getJ2eeType();
        if (j2eeType == null) {
            j2eeType = "GBean";
        }
        AbstractName abstractName = naming.createRootName(environment.getConfigId(), name, j2eeType);
        gBeanData.setAbstractName(abstractName);
        this.addGBean(gBeanData);
        return gBeanData;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.gbeanState == null) {
            this.gbeanState = SerializedGBeanState.storeGBeans(this.gbeans);
            this.gbeans.clear();
        }
        stream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<GBeanData> loadGBeans(byte[] gbeanState, Bundle bundle) throws InvalidConfigException {
        ArrayList<GBeanData> gbeans = new ArrayList<GBeanData>();
        if (gbeanState != null && gbeanState.length > 0) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                ObjectInputStreamExt ois = new ObjectInputStreamExt(new ByteArrayInputStream(gbeanState), bundle);
                try {
                    try {
                        while (true) {
                            GBeanData gbeanData = new GBeanData();
                            gbeanData.readExternal(ois);
                            gbeans.add(gbeanData);
                        }
                    }
                    catch (EOFException e) {
                        ois.close();
                    }
                }
                catch (Throwable throwable) {
                    ois.close();
                    throw throwable;
                }
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigException("Class not loadable in classloader: " + bundle, e);
            }
            catch (NoClassDefFoundError e) {
                throw new InvalidConfigException("Class not loadable in classloader: " + bundle, e);
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to deserialize GBeanState in classloader: " + bundle, e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        return gbeans;
    }

    private static byte[] storeGBeans(List<GBeanData> gbeans) throws IOException {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            oos = new ObjectOutputStream(baos);
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to initialize ObjectOutputStream"))).initCause(e));
        }
        for (GBeanData gbeanData : gbeans) {
            try {
                gbeanData.writeExternal(oos);
            }
            catch (Exception e) {
                System.err.println("FAILED TO SERIALIZE: " + gbeanData.getGBeanInfo());
                throw (IOException)new IOException("Unable to serialize GBeanData for " + gbeanData.getAbstractName()).initCause(e);
            }
        }
        try {
            oos.flush();
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to flush ObjectOutputStream"))).initCause(e));
        }
        return baos.toByteArray();
    }
}

