/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.CopyArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.UnpackArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.WriteableRepository;
import org.apache.geronimo.kernel.util.InputUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository
implements WriteableRepository {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ArtifactTypeHandler DEFAULT_TYPE_HANDLER = new CopyArtifactTypeHandler();
    protected final File rootFile;
    private final Map<String, ArtifactTypeHandler> typeHandlers = new HashMap<String, ArtifactTypeHandler>();

    public AbstractRepository(File rootFile) {
        if (rootFile == null) {
            throw new NullPointerException("root is null");
        }
        if (!(rootFile.exists() && rootFile.isDirectory() && rootFile.canRead())) {
            throw new IllegalStateException("Maven2Repository must have a root that's a valid readable directory (not " + rootFile.getAbsolutePath() + ")");
        }
        this.rootFile = rootFile;
        this.log.debug("Repository root is {}", (Object)rootFile.getAbsolutePath());
        this.typeHandlers.put("car", new UnpackArtifactTypeHandler());
    }

    @Override
    public boolean contains(Artifact artifact) {
        File location = this.getLocation(artifact);
        return location.canRead() && (location.isFile() || new File(location, "META-INF").isDirectory());
    }

    public void setTypeHandler(String type, ArtifactTypeHandler handler) {
        this.typeHandlers.put(type, handler);
    }

    @Override
    public void copyToRepository(File source, Artifact destination, FileWriteMonitor monitor) throws IOException {
        File location = this.verifyDestination(destination);
        if (!source.exists() || !source.canRead()) {
            throw new IllegalArgumentException("Cannot read source file at " + source.getAbsolutePath());
        }
        ArtifactTypeHandler typeHandler = this.typeHandlers.get(destination.getType());
        if (typeHandler == null) {
            typeHandler = DEFAULT_TYPE_HANDLER;
        }
        typeHandler.install(source, destination, monitor, location);
        if (destination.getType().equalsIgnoreCase("car")) {
            this.log.debug("Installed module configuration; id={}; location={}", (Object)destination, (Object)location);
        }
    }

    @Override
    public void copyToRepository(InputStream source, int size, Artifact destination, FileWriteMonitor monitor) throws IOException {
        File location = this.verifyDestination(destination);
        ArtifactTypeHandler typeHandler = this.typeHandlers.get(destination.getType());
        if (typeHandler == null) {
            typeHandler = DEFAULT_TYPE_HANDLER;
        }
        typeHandler.install(source, size, destination, monitor, location);
        if (destination.getType().equalsIgnoreCase("car")) {
            this.log.debug("Installed module configuration; id={}; location={}", (Object)destination, (Object)location);
        }
    }

    private File verifyDestination(Artifact destination) {
        if (!this.rootFile.canWrite()) {
            throw new IllegalStateException("This repository is not writable");
        }
        if (!destination.isResolved()) {
            throw new IllegalArgumentException("Artifact " + destination + " is not fully resolved");
        }
        InputUtils.validateSafeInput(Arrays.asList(destination.getGroupId(), destination.getArtifactId(), destination.getVersion().toString(), destination.getType()));
        File location = this.getLocation(destination);
        if (location.exists()) {
            throw new IllegalArgumentException("Destination " + location.getAbsolutePath() + " already exists!");
        }
        return location;
    }

    public File getRootFile() {
        return this.rootFile;
    }
}

