/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;

public class CopyArtifactTypeHandler
implements ArtifactTypeHandler {
    private static final int TRANSFER_NOTIFICATION_SIZE = 10240;
    private static final int TRANSFER_BUF_SIZE = 10240;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(InputStream source, int size, Artifact artifact, FileWriteMonitor monitor, File target) throws IOException {
        File parent = target.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create directory " + parent.getAbsolutePath());
        }
        if (monitor != null) {
            monitor.writeStarted(artifact.toString(), size);
        }
        int total = 0;
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            int count;
            int threshold = 10240;
            out = new BufferedOutputStream(new FileOutputStream(target));
            in = new BufferedInputStream(source);
            byte[] buf = new byte[10240];
            while ((count = in.read(buf)) > -1) {
                out.write(buf, 0, count);
                if (monitor == null || (total += count) <= threshold) continue;
                threshold += 10240;
                monitor.writeProgress(total);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            IOUtils.close(out);
            if (monitor != null) {
                monitor.writeComplete(total);
            }
            throw throwable;
        }
        IOUtils.close(in);
        IOUtils.close(out);
        if (monitor != null) {
            monitor.writeComplete(total);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(File source, Artifact artifactId, FileWriteMonitor monitor, File target) throws IOException {
        if (source.isFile()) {
            long size = monitor == null ? -1L : source.length();
            FileInputStream is = new FileInputStream(source);
            try {
                this.install(is, (int)size, artifactId, monitor, target);
            }
            finally {
                IOUtils.close(is);
            }
        } else {
            FileUtils.recursiveCopy(source, target);
        }
    }
}

