/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.NestedJarEntry;
import org.apache.geronimo.kernel.util.UnpackedJarEntry;
import org.apache.geronimo.kernel.util.UnpackedJarFile;

public class NestedJarFile
extends JarFile {
    private JarFile baseJar;
    private String basePath;
    private boolean isClosed = false;
    private boolean manifestLoaded = false;
    private Manifest manifest;
    private File tempFile;

    public NestedJarFile(JarFile jarFile, String path) throws IOException {
        super(JarUtils.DUMMY_JAR_FILE);
        JarEntry targetEntry = jarFile.getJarEntry(path + "/");
        if (targetEntry == null && (targetEntry = jarFile.getJarEntry(path)) == null) {
            throw new IOException("Jar entry does not exist: jarFile=" + jarFile.getName() + ", path=" + path);
        }
        if (targetEntry.isDirectory()) {
            if (targetEntry instanceof UnpackedJarEntry) {
                File targetFile = ((UnpackedJarEntry)targetEntry).getFile();
                this.baseJar = new UnpackedJarFile(targetFile);
                this.basePath = "";
            } else {
                this.baseJar = jarFile;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                this.basePath = path;
            }
        } else if (targetEntry instanceof UnpackedJarEntry) {
            File targetFile = ((UnpackedJarEntry)targetEntry).getFile();
            this.baseJar = new JarFile(targetFile);
            this.basePath = "";
        } else {
            this.tempFile = JarUtils.toFile(jarFile, targetEntry.getName());
            this.baseJar = new JarFile(this.tempFile);
            this.basePath = "";
        }
    }

    public boolean isUnpacked() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.basePath.length() > 0 || this.baseJar != null && this.baseJar instanceof UnpackedJarFile;
    }

    public boolean isPacked() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.basePath.length() == 0 && (this.baseJar == null || !(this.baseJar instanceof UnpackedJarFile));
    }

    public JarFile getBaseJar() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.baseJar;
    }

    public String getBasePath() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        if (!this.manifestLoaded) {
            JarEntry manifestEntry = this.getBaseEntry("META-INF/MANIFEST.MF");
            if (manifestEntry != null && !manifestEntry.isDirectory()) {
                InputStream in = null;
                try {
                    in = this.baseJar.getInputStream(manifestEntry);
                    this.manifest = new Manifest(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    public NestedJarEntry getNestedJarEntry(String name) {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        JarEntry baseEntry = this.getBaseEntry(name);
        if (baseEntry == null) {
            return null;
        }
        return new NestedJarEntry(name, baseEntry, this.getManifestSafe());
    }

    @Override
    public JarEntry getJarEntry(String name) {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.getNestedJarEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.getNestedJarEntry(name);
    }

    public Enumeration entries() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        ArrayList<JarEntry> baseEntries = Collections.list(this.baseJar.entries());
        LinkedList<NestedJarEntry> entries = new LinkedList<NestedJarEntry>();
        for (JarEntry baseEntry : baseEntries) {
            String path = baseEntry.getName();
            if (!path.startsWith(this.basePath)) continue;
            entries.add(new NestedJarEntry(path.substring(this.basePath.length()), baseEntry, this.getManifestSafe()));
        }
        return Collections.enumeration(entries);
    }

    @Override
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        JarEntry baseEntry = zipEntry instanceof NestedJarEntry ? ((NestedJarEntry)zipEntry).getBaseEntry() : this.getBaseEntry(zipEntry.getName());
        if (baseEntry == null) {
            throw new IOException("Entry not found: name=" + zipEntry.getName());
        }
        if (baseEntry.isDirectory()) {
            return new IOUtils.EmptyInputStream();
        }
        return this.baseJar.getInputStream(baseEntry);
    }

    @Override
    public String getName() {
        return this.baseJar.getName();
    }

    @Override
    public int size() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.baseJar != null && this.basePath.length() == 0) {
                this.baseJar.close();
            }
        }
        finally {
            this.isClosed = true;
            this.baseJar = null;
            this.basePath = null;
            this.manifestLoaded = false;
            this.manifest = null;
            if (this.tempFile != null) {
                this.tempFile.delete();
                this.tempFile = null;
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private JarEntry getBaseEntry(String name) {
        return this.baseJar.getJarEntry(this.basePath + name);
    }

    private Manifest getManifestSafe() {
        Manifest manifest = null;
        try {
            manifest = this.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return manifest;
    }
}

