/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public abstract class AbstractURLContextFactory
implements ObjectFactory {
    public String urlScheme;

    public AbstractURLContextFactory(String urlScheme) {
        this.urlScheme = urlScheme + ":";
    }

    @Override
    public Object getObjectInstance(Object o, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        if (o == null) {
            return this.getContext();
        }
        if (o instanceof String) {
            return this.getContext().lookup((String)o);
        }
        if (o instanceof String[]) {
            for (String s : (String[])o) {
                if (!s.startsWith(this.urlScheme)) continue;
                return this.getContext().lookup(s);
            }
        }
        return null;
    }

    protected abstract Context getContext() throws NamingException;
}

