/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.obr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.obr.ResourceBuilder;
import org.apache.geronimo.obr.model.Repository;
import org.apache.geronimo.obr.model.Resource;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
@OsgiService
public class GeronimoOBRGBean
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(GeronimoOBRGBean.class);
    public static final String REPOSITORY_NAME = "Geronimo OBR Repository";
    private BundleContext bundleContext;
    private ListableRepository repository;
    private File obrFile;
    private List<URL> repositories;
    private Set<Artifact> exclusions;

    public GeronimoOBRGBean(@ParamReference(name="Repository", namingType="Repository") ListableRepository repository, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamAttribute(name="repositoryList") String repositoryList, @ParamAttribute(name="exclusions") String exclusions) throws Exception {
        this.repository = repository;
        this.bundleContext = bundleContext;
        this.obrFile = serverInfo.resolveServer("var/obr.xml");
        this.repositories = GeronimoOBRGBean.parseRepositories(repositoryList);
        this.exclusions = GeronimoOBRGBean.parseExclusions(exclusions);
    }

    private static List<URL> parseRepositories(String repositoryList) throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        if (repositoryList != null) {
            StringTokenizer tokenizer = new StringTokenizer(repositoryList, ",");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                list.add(new URL(token.trim()));
            }
        }
        return list;
    }

    private static Set<Artifact> parseExclusions(String exclusions) throws MalformedURLException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        if (exclusions != null) {
            StringTokenizer tokenizer = new StringTokenizer(exclusions, ",");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                set.add(Artifact.create((String)token.trim()));
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        this.generateRepository();
        ServiceReference ref = this.bundleContext.getServiceReference(RepositoryAdmin.class.getName());
        RepositoryAdmin repositoryAdmin = (RepositoryAdmin)this.bundleContext.getService(ref);
        try {
            repositoryAdmin.removeRepository(this.obrFile.toURI().toURL().toExternalForm());
            repositoryAdmin.addRepository(this.obrFile.toURI().toURL());
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
    }

    private void generateRepository() throws Exception {
        ListableRepository geronimoRepository = this.repository;
        SortedSet artifacts = this.repository.list();
        for (Artifact excluded : this.exclusions) {
            Iterator iterator = artifacts.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                if (!excluded.matches(artifact)) continue;
                LOG.debug("Exluded {} artifact from OBR", (Object)artifact);
                iterator.remove();
            }
        }
        GeronimoOBRGBean.generateOBR(REPOSITORY_NAME, artifacts, (org.apache.geronimo.kernel.repository.Repository)geronimoRepository, this.obrFile);
    }

    public static void generateOBR(String obrName, Set<Artifact> artifacts, org.apache.geronimo.kernel.repository.Repository geronimoRepository, File obrFile) throws IOException, JAXBException {
        Repository repo = GeronimoOBRGBean.generateOBRModel(obrName, geronimoRepository, artifacts);
        GeronimoOBRGBean.marshallOBRModel(repo, obrFile);
    }

    public static void marshallOBRModel(Repository repo, File obrFile) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Repository.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)repo, obrFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Repository generateOBRModel(String obrName, org.apache.geronimo.kernel.repository.Repository geronimoRepository, Set<Artifact> artifacts) throws IOException {
        Repository repo = new Repository();
        repo.setName(obrName);
        for (Artifact artifact : artifacts) {
            File location = geronimoRepository.getLocation(artifact);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generating OBR Metadata for " + location.getAbsolutePath());
            }
            Manifest mf = null;
            if (location.isFile()) {
                JarFile file = new JarFile(location);
                try {
                    mf = file.getManifest();
                }
                finally {
                    try {
                        file.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            if (!location.isDirectory()) continue;
            File mfFile = new File(location, "META-INF/MANIFEST.MF");
            FileInputStream in = new FileInputStream(mfFile);
            try {
                mf = new Manifest(in);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
            if (mf == null) continue;
            BundleDescription desc = new BundleDescription(mf);
            ResourceBuilder builder = new ResourceBuilder(desc);
            Resource resource = null;
            try {
                resource = builder.createResource();
            }
            catch (RuntimeException e) {
                LOG.debug("Failed to generate OBR information for " + artifact + " artifact", (Throwable)e);
                continue;
            }
            if (resource != null) {
                resource.setUri(GeronimoOBRGBean.getURL(artifact));
                if (location.isFile()) {
                    resource.setSize(location.length());
                }
                repo.getResource().add(resource);
                continue;
            }
            LOG.debug("Did not generate OBR information for {} artifact. It is not a bundle.", (Object)artifact);
        }
        return repo;
    }

    private static String getURL(Artifact artifact) {
        return "mvn:" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + ("jar".equals(artifact.getType()) ? "" : "/" + artifact.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRepositories() throws Exception {
        ServiceReference ref = this.bundleContext.getServiceReference(RepositoryAdmin.class.getName());
        RepositoryAdmin repositoryAdmin = (RepositoryAdmin)this.bundleContext.getService(ref);
        try {
            repositoryAdmin.addRepository(this.obrFile.toURI().toURL());
            for (URL repository : this.repositories) {
                repositoryAdmin.addRepository(repository);
            }
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterRepositories() throws Exception {
        ServiceReference ref = this.bundleContext.getServiceReference(RepositoryAdmin.class.getName());
        RepositoryAdmin repositoryAdmin = (RepositoryAdmin)this.bundleContext.getService(ref);
        try {
            repositoryAdmin.removeRepository(this.obrFile.toURI().toURL().toExternalForm());
            for (URL repository : this.repositories) {
                repositoryAdmin.removeRepository(repository.toExternalForm());
            }
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
    }

    public void doStart() throws Exception {
        this.generateRepository();
        this.registerRepositories();
    }

    public void doStop() throws Exception {
        this.unregisterRepositories();
    }

    public void doFail() {
    }
}

