/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.obr;

import java.util.List;
import org.apache.geronimo.obr.model.Capability;
import org.apache.geronimo.obr.model.P;
import org.apache.geronimo.obr.model.Require;
import org.apache.geronimo.obr.model.Resource;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.VersionRange;

public class ResourceBuilder {
    private static String CAPABILITY_BUNDLE = "bundle";
    private static String CAPABILITY_PACKAGE = "package";
    private static String CAPABILITY_FRAGMENT = "fragment";
    private BundleDescription bundleDescription;

    public ResourceBuilder(BundleDescription bundleDescription) {
        this.bundleDescription = bundleDescription;
    }

    public Resource createResource() {
        BundleDescription.SymbolicName symbolicName = this.bundleDescription.getSymbolicName();
        if (symbolicName == null) {
            return null;
        }
        Resource resource = new Resource();
        resource.setId(String.valueOf(System.currentTimeMillis()));
        resource.setSymbolicname(symbolicName.getName());
        this.convertAttributesToProperties(resource);
        this.convertImportPackageToRequirement(resource);
        this.convertRequireBundleToRequirement(resource);
        this.convertRequireExecutionEnvironmentToRequirement(resource);
        this.convertFragmentHostToExtends(resource);
        this.convertBundleToCapability(resource, symbolicName);
        this.convertExportPackageToCapability(resource);
        return resource;
    }

    private String getProperty(String name) {
        return (String)this.bundleDescription.getHeaders().get(name);
    }

    private void convertAttributesToProperties(Resource resource) {
        String bundleName = this.getProperty("Bundle-Name");
        if (bundleName == null) {
            bundleName = resource.getSymbolicname();
        }
        resource.setPresentationname(bundleName);
        resource.setVersion(this.getProperty("Bundle-Version"));
        resource.setDescription(this.getProperty("Bundle-Description"));
        resource.setDocumentation(this.getProperty("Bundle-DocURL"));
        resource.setSource(this.getProperty("Bundle-Source"));
        resource.setLicense(this.getProperty("Bundle-License"));
    }

    private void convertImportPackageToRequirement(Resource resource) {
        List imports = this.bundleDescription.getImportPackage();
        for (BundleDescription.ImportPackage importPackage : imports) {
            Require require = new Require();
            require.setMultiple(false);
            require.setOptional(importPackage.isOptional());
            require.setName(CAPABILITY_PACKAGE);
            require.setContent("Import-Package: " + importPackage.getName());
            VersionRange range = importPackage.getVersionRange();
            String versionFilter = this.getVersionFilter(range);
            require.setFilter("(&(package=" + importPackage.getName() + ")" + versionFilter + ")");
            resource.getRequire().add(require);
        }
    }

    private void convertRequireBundleToRequirement(Resource resource) {
        List requireBundles = this.bundleDescription.getRequireBundle();
        for (BundleDescription.RequireBundle requireBundle : requireBundles) {
            Require require = new Require();
            require.setMultiple(false);
            require.setOptional(requireBundle.isOptional());
            require.setName(CAPABILITY_BUNDLE);
            require.setContent("Require-Bundle: " + requireBundle.getName());
            VersionRange range = requireBundle.getVersionRange();
            String versionExpression = this.getVersionFilter(range);
            require.setFilter("(&(symbolicname=" + requireBundle.getName() + ")" + versionExpression + ")");
            resource.getRequire().add(require);
        }
    }

    private void convertRequireExecutionEnvironmentToRequirement(Resource resource) {
        String[] envs;
        String requiredEnvironments = this.getProperty("Bundle-RequiredExecutionEnvironment");
        if (requiredEnvironments != null && (envs = requiredEnvironments.split(",")).length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("(|");
            for (String env : envs) {
                sb.append("(ee=");
                sb.append(env);
                sb.append(")");
            }
            sb.append(")");
            Require require = new Require();
            require.setName("ee");
            require.setContent("Execution Environment " + sb);
            require.setFilter(sb.toString());
            resource.getRequire().add(require);
        }
    }

    private void convertFragmentHostToExtends(Resource resource) {
        BundleDescription.FragmentHost fragment = this.bundleDescription.getFragmentHost();
        if (fragment != null) {
            Require require = new Require();
            require.setExtend(true);
            require.setMultiple(false);
            require.setOptional(false);
            require.setName(CAPABILITY_BUNDLE);
            require.setContent("Required Host: " + fragment.getName());
            VersionRange range = fragment.getVersionRange();
            String versionExpression = this.getVersionFilter(range);
            require.setFilter("(&(symbolicname=" + fragment.getName() + ")" + versionExpression + ")");
            resource.getRequire().add(require);
            Capability cap = new Capability();
            cap.setName(CAPABILITY_FRAGMENT);
            cap.getP().add(this.createP("host", null, fragment.getName()));
            cap.getP().add(this.createP("version", "version", "0.0.0"));
            resource.getCapability().add(cap);
        }
    }

    private void convertExportPackageToCapability(Resource resource) {
        List exports = this.bundleDescription.getExportPackage();
        for (BundleDescription.ExportPackage exportPackage : exports) {
            Capability cap = new Capability();
            cap.setName(CAPABILITY_PACKAGE);
            cap.getP().add(this.createP("package", null, exportPackage.getName()));
            cap.getP().add(this.createP("version", "version", exportPackage.getVersion().toString()));
            resource.getCapability().add(cap);
        }
    }

    private void convertBundleToCapability(Resource resource, BundleDescription.SymbolicName symbolicName) {
        String singleton;
        Capability cap = new Capability();
        cap.setName(CAPABILITY_BUNDLE);
        cap.getP().add(this.createP("symbolicname", null, symbolicName.getName()));
        cap.getP().add(this.createP("version", "version", this.bundleDescription.getVersion().toString()));
        cap.getP().add(this.createP("manifestversion", "version", (String)this.bundleDescription.getHeaders().get("Bundle-ManifestVersion")));
        String attachment = (String)symbolicName.getDirectives().get("fragment-attachment");
        if (attachment != null) {
            cap.getP().add(this.createP("fragment-attachment", null, attachment));
        }
        if ((singleton = (String)symbolicName.getDirectives().get("singleton")) != null) {
            cap.getP().add(this.createP("singleton", null, singleton));
        }
        resource.getCapability().add(cap);
    }

    private P createP(String name, String type, String value) {
        P p = new P();
        p.setN(name);
        p.setV(value);
        p.setT(type);
        return p;
    }

    private String getVersionFilter(VersionRange range) {
        String low;
        String string = low = range.isLowInclusive() ? "(version>=" + range.getLow() + ")" : "(!(version<=" + range.getLow() + "))";
        if (range.getHigh() != null) {
            String high = range.isHighInclusive() ? "(version<=" + range.getHigh() + ")" : "(!(version>=" + range.getHigh() + "))";
            return low + high;
        }
        return low;
    }
}

