/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.security.SecurityServiceImpl;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class GeronimoLoginConfiguration
extends Configuration
implements GBeanLifecycle,
ReferenceCollectionListener {
    private static final Logger log = LoggerFactory.getLogger(GeronimoLoginConfiguration.class);
    private final Map<String, AppConfigurationEntry[]> entries = new ConcurrentHashMap<String, AppConfigurationEntry[]>();
    private Configuration oldConfiguration;
    private final Collection<ConfigurationEntryFactory> configurations;
    private final boolean useAllConfigurations;

    public GeronimoLoginConfiguration(@ParamReference(name="Configurations", namingType="SecurityRealm") Collection<ConfigurationEntryFactory> configurations, @ParamAttribute(name="useAllConfigurations") boolean useAllConfigurations) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        if (configurations instanceof ReferenceCollection) {
            ReferenceCollection ref = (ReferenceCollection)configurations;
            ref.addReferenceCollectionListener((ReferenceCollectionListener)this);
        }
        this.configurations = configurations;
        this.useAllConfigurations = useAllConfigurations;
        for (ConfigurationEntryFactory configuration : configurations) {
            this.addConfiguration(configuration);
        }
    }

    public Collection<ConfigurationEntryFactory> getConfigurations() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        return this.configurations;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public void refresh() {
    }

    public void memberAdded(ReferenceCollectionEvent event) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        ConfigurationEntryFactory factory = (ConfigurationEntryFactory)event.getMember();
        this.addConfiguration(factory);
    }

    public void memberRemoved(ReferenceCollectionEvent event) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        ConfigurationEntryFactory factory = (ConfigurationEntryFactory)event.getMember();
        this.entries.remove(factory.getConfigurationName());
        log.debug("Removed Application Configuration Entry " + factory.getConfigurationName());
    }

    private void addConfiguration(ConfigurationEntryFactory factory) {
        if (this.useAllConfigurations || factory.isGlobal()) {
            if (this.entries.containsKey(factory.getConfigurationName())) {
                throw new IllegalArgumentException("ConfigurationEntry named: " + factory.getConfigurationName() + " already registered");
            }
            AppConfigurationEntry[] ace = factory.getAppConfigurationEntries();
            this.entries.put(factory.getConfigurationName(), ace);
            log.debug("Added Application Configuration Entry " + factory.getConfigurationName());
        }
    }

    public void doStart() throws Exception {
        try {
            this.oldConfiguration = Configuration.getConfiguration();
        }
        catch (SecurityException e) {
            this.oldConfiguration = null;
        }
        Configuration.setConfiguration(this);
        log.debug("Installed Geronimo login configuration");
    }

    public void doStop() throws Exception {
        Configuration.setConfiguration(this.oldConfiguration);
        for (String s : this.entries.keySet()) {
            log.debug("Removed Application Configuration Entry " + s);
        }
        this.entries.clear();
        log.debug("Uninstalled Geronimo login configuration");
    }

    public void doFail() {
        Configuration.setConfiguration(this.oldConfiguration);
        log.debug("Uninstalled Geronimo login configuration");
    }
}

