/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.io.Serializable;
import java.security.Principal;

public class DomainPrincipal
implements Principal,
Serializable {
    private final String domain;
    private final Principal principal;
    private transient String name = null;

    public DomainPrincipal(String domain, Principal principal) {
        if (domain == null) {
            throw new IllegalArgumentException("domain is null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal is null");
        }
        this.domain = domain;
        this.principal = principal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainPrincipal that = (DomainPrincipal)o;
        if (!this.domain.equals(that.domain)) {
            return false;
        }
        return ((Object)this.principal).equals(that.principal);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        int result = this.domain.hashCode();
        result = 29 * result + ((Object)this.principal).hashCode();
        return result;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            StringBuilder buffer = new StringBuilder("");
            buffer.append(this.domain);
            buffer.append("::");
            buffer.append(this.principal.getClass().getName());
            buffer.append(':');
            buffer.append(this.principal.getName());
            buffer.append("]");
            this.name = buffer.toString();
        }
        return this.name;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getDomain() {
        return this.domain;
    }
}

