/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.io.Serializable;
import java.security.Principal;

public class RealmPrincipal
implements Principal,
Serializable {
    private final String realm;
    private final String domain;
    private final Principal principal;
    private transient String name = null;

    public RealmPrincipal(String realm, String domain, Principal principal) {
        if (realm == null) {
            throw new IllegalArgumentException("realm is null");
        }
        if (domain == null) {
            throw new IllegalArgumentException("domain is null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal is null");
        }
        this.realm = realm;
        this.domain = domain;
        this.principal = principal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmPrincipal that = (RealmPrincipal)o;
        if (!this.domain.equals(that.domain)) {
            return false;
        }
        if (!((Object)this.principal).equals(that.principal)) {
            return false;
        }
        return this.realm.equals(that.realm);
    }

    @Override
    public int hashCode() {
        int result = this.realm.hashCode();
        result = 29 * result + this.domain.hashCode();
        result = 29 * result + ((Object)this.principal).hashCode();
        return result;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            StringBuilder buffer = new StringBuilder("");
            buffer.append(this.realm);
            buffer.append("::");
            buffer.append(this.domain);
            buffer.append("::");
            buffer.append(this.principal.getClass().getName());
            buffer.append(':');
            buffer.append(this.principal.getName());
            this.name = buffer.toString();
        }
        return this.name;
    }

    public String getRealm() {
        return this.realm;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getLoginDomain() {
        return this.domain;
    }
}

