/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc.mappingprovider;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfiguration;
import org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfigurationFactory;

public class GeronimoPolicy
extends Policy {
    private final Policy root;
    private GeronimoPolicyConfigurationFactory factory;
    private boolean loaded;

    public GeronimoPolicy() {
        String provider = System.getProperty("org.apache.geronimo.jacc.policy.provider");
        if (provider == null) {
            this.root = Policy.getPolicy();
        } else {
            try {
                Object obj = Class.forName(provider).newInstance();
                if (!(obj instanceof Policy)) {
                    throw new RuntimeException(provider + "is not a type of java.security.Policy");
                }
                this.root = (Policy)obj;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to create an instance of " + provider, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to create an instance of " + provider, e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to create an instance of " + provider, e);
            }
        }
        this.root.refresh();
        GeronimoPolicyConfigurationFactory.getSingleton();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        if (this.root != null) {
            return this.root.getPermissions(codesource);
        }
        return null;
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        block7: {
            String contextID;
            if (!this.loaded) {
                this.factory = GeronimoPolicyConfigurationFactory.getSingleton();
                this.loaded = true;
            }
            if (this.factory != null && (contextID = PolicyContext.getContextID()) != null) {
                try {
                    GeronimoPolicyConfiguration configuration = this.factory.getGeronimoPolicyConfiguration(contextID);
                    if (configuration.inService()) {
                        if (configuration.implies(domain, permission)) {
                            return true;
                        }
                        break block7;
                    }
                    return false;
                }
                catch (PolicyContextException e) {
                    // empty catch block
                }
            }
        }
        if (this.root != null) {
            return this.root.implies(domain, permission);
        }
        return false;
    }
}

