/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaspi.impl;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.CertStoreCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.callback.PrivateKeyCallback;
import javax.security.auth.message.callback.SecretKeyCallback;
import javax.security.auth.message.callback.TrustStoreCallback;
import org.apache.geronimo.security.jaspi.LoginService;
import org.apache.geronimo.security.jaspi.UserIdentity;
import org.apache.geronimo.security.jaspi.impl.WrappingCallerPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;

public class JaspicCallbackHandler
implements CallbackHandler {
    private final LoginService loginService;

    public JaspicCallbackHandler(LoginService loginService) {
        this.loginService = loginService;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CallerPrincipalCallback) {
                Principal callerPrincipal;
                CallerPrincipalCallback callerPrincipalCallback = (CallerPrincipalCallback)callback;
                if (callerPrincipalCallback.getPrincipal() != null) {
                    callerPrincipal = callerPrincipalCallback.getPrincipal();
                    callerPrincipalCallback.getSubject().getPrincipals().add(callerPrincipal);
                    callerPrincipalCallback.getSubject().getPrincipals().add(new WrappingCallerPrincipal(callerPrincipal));
                    continue;
                }
                if (callerPrincipalCallback.getName() == null) continue;
                callerPrincipal = new GeronimoUserPrincipal(callerPrincipalCallback.getName());
                callerPrincipalCallback.getSubject().getPrincipals().add(callerPrincipal);
                callerPrincipalCallback.getSubject().getPrincipals().add(new WrappingCallerPrincipal(callerPrincipal));
                continue;
            }
            if (callback instanceof GroupPrincipalCallback) {
                GroupPrincipalCallback groupPrincipalCallback = (GroupPrincipalCallback)callback;
                if (groupPrincipalCallback.getGroups() == null) continue;
                Set<Principal> principalSet = groupPrincipalCallback.getSubject().getPrincipals();
                for (String groupName : groupPrincipalCallback.getGroups()) {
                    principalSet.add(new GeronimoGroupPrincipal(groupName));
                }
                continue;
            }
            if (callback instanceof PasswordValidationCallback) {
                PasswordValidationCallback passwordValidationCallback = (PasswordValidationCallback)callback;
                Subject subject = passwordValidationCallback.getSubject();
                UserIdentity user = this.loginService.login(passwordValidationCallback.getUsername(), new String(passwordValidationCallback.getPassword()));
                if (user == null) continue;
                passwordValidationCallback.setResult(true);
                subject.getPrincipals().addAll(user.getSubject().getPrincipals());
                subject.getPrivateCredentials().add(user);
                continue;
            }
            if (callback instanceof CertStoreCallback || callback instanceof PrivateKeyCallback || callback instanceof SecretKeyCallback || callback instanceof TrustStoreCallback) continue;
            throw new UnsupportedCallbackException(callback);
        }
    }
}

