/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.login;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.crypto.encoders.Base64;
import org.apache.geronimo.crypto.encoders.HexTranslator;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.security.jaas.LoginModuleSettings;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoginModuleManager
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(PropertiesLoginModuleManager.class);
    private ServerInfo serverInfo;
    private SingleElementCollection<LoginModuleSettings> loginModule;
    private Properties users = new Properties();
    private Properties groups = new Properties();
    private static final String usersKey = "usersURI";
    private static final String groupsKey = "groupsURI";
    private static final String digestKey = "digest";
    private static final String encodingKey = "encoding";
    public static final GBeanInfo GBEAN_INFO;

    public PropertiesLoginModuleManager(ServerInfo serverInfo, Collection<LoginModuleSettings> loginModule) {
        this.serverInfo = serverInfo;
        this.loginModule = new SingleElementCollection(loginModule);
    }

    public boolean isAvailable() {
        return this.loginModule.getElement() != null;
    }

    private void refreshUsers() throws GeronimoSecurityException {
        this.users.clear();
        InputStream in = null;
        try {
            in = this.serverInfo.resolveServer(this.getUsersURI()).toURL().openStream();
            this.users.load(in);
        }
        catch (Exception e) {
            throw new GeronimoSecurityException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private void refreshGroups() throws GeronimoSecurityException {
        this.groups.clear();
        InputStream in = null;
        try {
            in = this.serverInfo.resolveServer(this.getGroupsURI()).toURL().openStream();
            this.groups.load(in);
        }
        catch (Exception e) {
            throw new GeronimoSecurityException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private void clearAll() {
        this.users.clear();
        this.groups.clear();
    }

    public void refreshAll() throws GeronimoSecurityException {
        this.refreshGroups();
        this.refreshUsers();
    }

    public String[] getUsers() throws GeronimoSecurityException {
        this.refreshUsers();
        return this.users.keySet().toArray(new String[0]);
    }

    public String[] getGroups() throws GeronimoSecurityException {
        this.refreshGroups();
        return this.groups.keySet().toArray(new String[0]);
    }

    public void addUserPrincipal(Hashtable<String, String> properties) throws GeronimoSecurityException {
        this.refreshUsers();
        String name = properties.get("UserName");
        if (this.users.getProperty(name) != null) {
            log.warn("addUserPrincipal() UserName=" + name + " already exists.");
            throw new GeronimoSecurityException("User principal=" + name + " already exists.");
        }
        try {
            String realPassword = properties.get("Password");
            if (realPassword != null) {
                String digest = this.getDigest();
                if (digest != null && !digest.equals("")) {
                    realPassword = this.digestPassword(realPassword, digest, this.getEncoding());
                }
                realPassword = EncryptionManager.encrypt((Serializable)((Object)realPassword));
            }
            this.users.setProperty(name, realPassword);
            this.store(this.users, this.serverInfo.resolveServer(this.getUsersURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot add user principal: " + e.getMessage(), (Throwable)e);
        }
    }

    public void removeUserPrincipal(String userPrincipal) throws GeronimoSecurityException {
        this.refreshUsers();
        try {
            this.users.remove(userPrincipal);
            this.store(this.users, this.serverInfo.resolveServer(this.getUsersURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot remove user principal " + userPrincipal + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateUserPrincipal(Hashtable<String, String> properties) throws GeronimoSecurityException {
        this.refreshUsers();
        String name = properties.get("UserName");
        if (this.users.getProperty(name) == null) {
            log.warn("updateUserPrincipal() UserName=" + name + " does not exist.");
            throw new GeronimoSecurityException("User principal=" + name + " does not exist.");
        }
        try {
            String realPassword = properties.get("Password");
            if (realPassword != null) {
                String digest = this.getDigest();
                if (digest != null && !digest.equals("")) {
                    realPassword = this.digestPassword(realPassword, digest, this.getEncoding());
                }
                realPassword = EncryptionManager.encrypt((Serializable)((Object)realPassword));
            }
            this.users.setProperty(name, realPassword);
            this.store(this.users, this.serverInfo.resolveServer(this.getUsersURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot update user principal: " + e.getMessage(), (Throwable)e);
        }
    }

    public void addGroupPrincipal(Hashtable<String, String> properties) throws GeronimoSecurityException {
        this.refreshGroups();
        String group = properties.get("GroupName");
        if (this.groups.getProperty(group) != null) {
            log.warn("addGroupPrincipal() GroupName=" + group + " already exists.");
            throw new GeronimoSecurityException("Group principal=" + group + " already exists.");
        }
        try {
            this.groups.setProperty(group, properties.get("Members"));
            this.store(this.groups, this.serverInfo.resolveServer(this.getGroupsURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot add group principal: " + e.getMessage(), (Throwable)e);
        }
    }

    public void removeGroupPrincipal(String groupPrincipal) throws GeronimoSecurityException {
        this.refreshGroups();
        try {
            this.groups.remove(groupPrincipal);
            this.store(this.groups, this.serverInfo.resolveServer(this.getGroupsURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot remove group principal: " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateGroupPrincipal(Hashtable<String, String> properties) throws GeronimoSecurityException {
        this.refreshGroups();
        String group = properties.get("GroupName");
        if (this.groups.getProperty(group) == null) {
            log.warn("updateGroupPrincipal() GroupName=" + group + " does not exist.");
            throw new GeronimoSecurityException("Group principal=" + group + " does not exist.");
        }
        try {
            this.groups.setProperty(group, properties.get("Members"));
            this.store(this.groups, this.serverInfo.resolveServer(this.getGroupsURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot update group principal: " + e.getMessage(), (Throwable)e);
        }
    }

    public void addToGroup(String userPrincipal, String groupPrincipal) throws GeronimoSecurityException {
        throw new GeronimoSecurityException("Not implemented for properties file security realm...");
    }

    public void removeFromGroup(String userPrincipal, String groupPrincipal) throws GeronimoSecurityException {
        throw new GeronimoSecurityException("Not implemented for properties file security realm...");
    }

    public String getPassword(String userPrincipal) throws GeronimoSecurityException {
        this.refreshUsers();
        if (this.users.getProperty(userPrincipal) == null) {
            log.warn("getPassword() User=" + userPrincipal + " does not exist.");
            throw new GeronimoSecurityException("User principal=" + userPrincipal + " does not exist.");
        }
        String realPassword = this.users.getProperty(userPrincipal);
        if (realPassword != null) {
            realPassword = (String)((Object)EncryptionManager.decrypt((String)realPassword));
        }
        return realPassword;
    }

    public Set<String> getGroupMembers(String groupPrincipal) throws GeronimoSecurityException {
        HashSet<String> memberSet = new HashSet<String>();
        if (groupPrincipal == null || groupPrincipal.equals("")) {
            return memberSet;
        }
        this.refreshGroups();
        if (this.groups.getProperty(groupPrincipal) == null) {
            log.warn("getGroupMembers() Group=" + groupPrincipal + " does not exist.");
            return memberSet;
        }
        String[] members = this.groups.getProperty(groupPrincipal).split(",");
        memberSet.addAll(Arrays.asList(members));
        return memberSet;
    }

    private String getUsersURI() {
        return (String)((LoginModuleSettings)this.loginModule.getElement()).getOptions().get(usersKey);
    }

    private String getGroupsURI() {
        return (String)((LoginModuleSettings)this.loginModule.getElement()).getOptions().get(groupsKey);
    }

    private String getDigest() {
        return (String)((LoginModuleSettings)this.loginModule.getElement()).getOptions().get(digestKey);
    }

    private String getEncoding() {
        return (String)((LoginModuleSettings)this.loginModule.getElement()).getOptions().get(encodingKey);
    }

    private void encryptAllPasswords() throws GeronimoSecurityException {
        log.debug("Checking passwords to see if any need encrypting");
        this.refreshAll();
        try {
            boolean bUpdates = false;
            Enumeration<Object> e = this.users.keys();
            while (e.hasMoreElements()) {
                String pw;
                String name = (String)e.nextElement();
                String realPassword = this.users.getProperty(name);
                if (realPassword == null || realPassword.equals(pw = EncryptionManager.encrypt((Serializable)((Object)realPassword)))) continue;
                this.users.setProperty(name, pw);
                bUpdates = true;
            }
            if (bUpdates) {
                log.debug("Found password(s) that needed encrypting");
                this.store(this.users, this.serverInfo.resolveServer(this.getUsersURI()).toURL());
            }
        }
        catch (Exception e) {
            log.error("encryptAllPasswords failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Properties props, URL url) throws Exception {
        OutputStream out = null;
        log.debug("Updating properties file=" + url.toExternalForm());
        try {
            try {
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                out = con.getOutputStream();
            }
            catch (Exception e) {
                if ("file".equalsIgnoreCase(url.getProtocol()) && e instanceof UnknownServiceException) {
                    out = new FileOutputStream(new File(url.getFile()));
                }
                throw e;
            }
            props.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private String digestPassword(String password, String algorithm, String encoding) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] data = md.digest(password.getBytes());
        if (encoding == null || "hex".equalsIgnoreCase(encoding)) {
            byte[] hexData = new byte[data.length * 2];
            HexTranslator ht = new HexTranslator();
            ht.encode(data, 0, data.length, hexData, 0);
            return new String(hexData);
        }
        if ("base64".equalsIgnoreCase(encoding)) {
            return new String(Base64.encode((byte[])data));
        }
        return "";
    }

    public void doFail() {
        log.warn("Failed");
    }

    public void doStart() throws Exception {
        log.debug("Starting gbean");
        if (!this.isAvailable()) {
            log.warn("Could not find the default properties-login login module");
            return;
        }
        this.encryptAllPasswords();
        log.debug("Started gbean");
    }

    public void doStop() throws Exception {
        log.debug("Stopping gbean");
        this.clearAll();
        log.debug("Stopped gbean");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"PropertiesLoginModuleManager", PropertiesLoginModuleManager.class);
        infoFactory.addOperation("addUserPrincipal", new Class[]{Hashtable.class}, Void.TYPE.getName());
        infoFactory.addOperation("removeUserPrincipal", new Class[]{String.class}, Void.TYPE.getName());
        infoFactory.addOperation("updateUserPrincipal", new Class[]{Hashtable.class}, Void.TYPE.getName());
        infoFactory.addOperation("getGroups", String[].class.getName());
        infoFactory.addOperation("getUsers", String[].class.getName());
        infoFactory.addOperation("refreshAll", Void.TYPE.getName());
        infoFactory.addOperation("updateUserPrincipal", new Class[]{Hashtable.class}, Void.TYPE.getName());
        infoFactory.addOperation("getPassword", new Class[]{String.class}, Void.TYPE.getName());
        infoFactory.addOperation("getGroupMembers", new Class[]{String.class}, Void.TYPE.getName());
        infoFactory.addOperation("addGroupPrincipal", new Class[]{Hashtable.class}, Void.TYPE.getName());
        infoFactory.addOperation("removeGroupPrincipal", new Class[]{String.class}, Void.TYPE.getName());
        infoFactory.addOperation("updateGroupPrincipal", new Class[]{Hashtable.class}, Void.TYPE.getName());
        infoFactory.addOperation("addToGroup", new Class[]{String.class, String.class}, Void.TYPE.getName());
        infoFactory.addOperation("removeFromGroup", new Class[]{String.class, String.class}, Void.TYPE.getName());
        infoFactory.addOperation("isAvailable", Boolean.TYPE.getName());
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("LoginModule", LoginModuleSettings.class, "LoginModule");
        infoFactory.setConstructor(new String[]{"ServerInfo", "LoginModule"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

