/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.GenericHttpHeaderLoginmodule;
import org.apache.geronimo.security.realm.providers.HeaderMismatchException;
import org.apache.geronimo.security.realm.providers.RequestCallback;
import org.apache.geronimo.security.realm.providers.SiteminderHeaderHandler;

public class GenericHttpHeaderSqlLoginmodule
extends GenericHttpHeaderLoginmodule
implements LoginModule {
    private static Log log = LogFactory.getLog(GenericHttpHeaderSqlLoginmodule.class);
    private static final String GROUP_SELECT = "groupSelect";
    private static final String USER = "jdbcUser";
    private static final String DATABASE_POOL_NAME = "dataSourceName";
    private static final String DATABASE_POOL_APP_NAME = "dataSourceApplication";
    private static final String HEADER_NAMES = "headerNames";
    private static final String AUTHENTICATION_AUTHORITY = "authenticationAuthority";
    private static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("groupSelect", "jdbcUser", "dataSourceName", "dataSourceApplication", "headerNames", "authenticationAuthority"));
    private String groupSelect;
    private DataSource dataSource;

    @Override
    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.username = null;
            this.groups.clear();
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded && this.username != null) {
            super.commitHelper();
        }
        this.username = null;
        this.groups.clear();
        return this.loginSucceeded;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        for (String option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn((Object)("Ignoring option: " + option + ". Not supported."));
        }
        this.headerNames = (String)options.get(HEADER_NAMES);
        this.authenticationAuthority = (String)options.get(AUTHENTICATION_AUTHORITY);
        this.groupSelect = (String)options.get(GROUP_SELECT);
        String dataSourceName = (String)options.get(DATABASE_POOL_NAME);
        if (dataSourceName != null) {
            dataSourceName = dataSourceName.trim();
            String dataSourceAppName = (String)options.get(DATABASE_POOL_APP_NAME);
            dataSourceAppName = dataSourceAppName == null || dataSourceAppName.trim().equals("") ? "null" : dataSourceAppName.trim();
            String kernelName = (String)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL");
            Kernel kernel = KernelRegistry.getKernel((String)kernelName);
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.put("name", dataSourceName);
            nameMap.put("J2EEApplication", dataSourceAppName);
            nameMap.put("j2eeType", "JCAConnectionManager");
            Set set = kernel.listGBeans(new AbstractNameQuery(null, nameMap));
            for (AbstractName name : set) {
                try {
                    this.dataSource = (DataSource)kernel.invoke(name, "createConnectionFactory");
                    break;
                }
                catch (GBeanNotFoundException e) {
                }
                catch (NoSuchOperationException e) {
                }
                catch (Exception e) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        Map<String, String> headerMap = null;
        this.loginSucceeded = false;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement statement = null;
        Callback[] callbacks = new Callback[]{new RequestCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.httpRequest = ((RequestCallback)callbacks[0]).getRequest();
        String[] headers = this.headerNames.split(",");
        try {
            headerMap = this.matchHeaders(this.httpRequest, headers);
        }
        catch (HeaderMismatchException e) {
            throw (LoginException)new LoginException("Header Mistmatch error").initCause(e);
        }
        if (headerMap.isEmpty()) {
            throw new FailedLoginException();
        }
        if (this.authenticationAuthority.equalsIgnoreCase("Siteminder")) {
            SiteminderHeaderHandler headerHandler = new SiteminderHeaderHandler();
            this.username = headerHandler.getUser(headerMap);
        } else if (this.authenticationAuthority.equalsIgnoreCase("Datapower")) {
            // empty if block
        }
        if (this.username == null || this.username.equals("")) {
            this.username = null;
            throw new FailedLoginException();
        }
        if (this.dataSource != null) {
            try {
                conn = this.dataSource.getConnection();
                try {
                    statement = conn.prepareStatement(this.groupSelect);
                    int count = GenericHttpHeaderSqlLoginmodule.countParameters(this.groupSelect);
                    for (int i = 0; i < count; ++i) {
                        statement.setObject(i + 1, this.username);
                    }
                    result = statement.executeQuery();
                    while (result.next()) {
                        String userName = result.getString(1);
                        String groupName = result.getString(2);
                        if (!userName.equals(this.username)) continue;
                        this.groups.add(groupName);
                    }
                    if (this.groups.isEmpty()) {
                        log.error((Object)("No roles associated with user " + this.username));
                        this.loginSucceeded = false;
                        throw new FailedLoginException();
                    }
                    this.loginSucceeded = true;
                }
                finally {
                    result.close();
                    statement.close();
                    conn.close();
                }
            }
            catch (LoginException e) {
                this.username = null;
                this.groups.clear();
                throw e;
            }
            catch (SQLException sqle) {
                this.username = null;
                this.groups.clear();
                throw (LoginException)new LoginException("SQL error").initCause(sqle);
            }
            catch (Exception e) {
                this.username = null;
                this.groups.clear();
                throw (LoginException)new LoginException("Could not access datasource").initCause(e);
            }
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.username = null;
        this.groups.clear();
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }

    private static int countParameters(String sql) {
        int count = 0;
        int pos = -1;
        while ((pos = sql.indexOf(63, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }
}

