/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.Serializable;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public class GeronimoPasswordCredential
implements Destroyable,
Serializable {
    private String userName;
    private char[] password;
    private boolean destroyed;

    public GeronimoPasswordCredential(String userName, char[] password) {
        assert (userName != null);
        assert (password != null);
        this.userName = userName;
        this.password = (char[])password.clone();
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getPassword() {
        return (char[])this.password.clone();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.userName = null;
        Arrays.fill(this.password, ' ');
        this.password = null;
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

