/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileNoPasswordLoginModule
implements LoginModule {
    public static final String GROUPS_URI = "groupsURI";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("groupsURI"));
    private static final Logger log = LoggerFactory.getLogger(PropertiesFileNoPasswordLoginModule.class);
    final Map<String, Set<String>> groups = new HashMap<String, Set<String>>();
    private boolean loginSucceeded;
    private Subject subject;
    private CallbackHandler handler;
    private String username;
    private final Set<Principal> allPrincipals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
        try {
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            String groups = (String)options.get(GROUPS_URI);
            URI groupsURI = new URI(groups);
            this.loadProperties(serverInfo, groupsURI);
        }
        catch (Exception e) {
            log.error("Initialization failed", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage(), e);
        }
    }

    public void loadProperties(ServerInfo serverInfo, URI groupURI) throws GeronimoSecurityException {
        try {
            URI groupFile = serverInfo.resolveServer(groupURI);
            Properties temp = new Properties();
            InputStream stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                Set<String> userset = this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                userset.addAll(Arrays.asList(userList));
            }
        }
        catch (Exception e) {
            log.error("Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new NameCallback("User name")};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            return false;
        }
        assert (callbacks.length == 1);
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null || this.username.equals("")) {
            this.username = null;
            throw new FailedLoginException();
        }
        this.loginSucceeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            if (this.username != null) {
                this.allPrincipals.add(new GeronimoUserPrincipal(this.username));
            }
            block0: for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
                String groupName = entry.getKey();
                Set<String> users = entry.getValue();
                for (String user : users) {
                    if (!this.username.equals(user)) continue;
                    this.allPrincipals.add(new GeronimoGroupPrincipal(groupName));
                    continue block0;
                }
            }
            this.subject.getPrincipals().addAll(this.allPrincipals);
        }
        this.username = null;
        return this.loginSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.username = null;
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.username = null;
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }
}

