/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.x500.X500Principal;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.security.DomainPrincipal;
import org.apache.geronimo.security.PrimaryDomainPrincipal;
import org.apache.geronimo.security.PrimaryPrincipal;
import org.apache.geronimo.security.PrimaryRealmPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.deploy.PrincipalInfo;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationUtil.class);

    public static X500Principal generateX500Principal(String name) {
        return new X500Principal(name);
    }

    public static Principal generatePrincipal(PrincipalInfo principalInfo, Bundle bundle) {
        return ConfigurationUtil.generatePrincipal(principalInfo.getClassName(), principalInfo.getPrincipalName(), bundle);
    }

    public static Principal generatePrincipal(final String className, final String principalName, final Bundle bundle) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Principal>(){

                @Override
                public Principal run() throws Exception {
                    Class clazz = bundle.loadClass(className);
                    try {
                        Constructor constructor = clazz.getDeclaredConstructor(String.class);
                        return (Principal)constructor.newInstance(principalName);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor<?>[] constructors;
                        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                            Class<?>[] paramTypes = constructor.getParameterTypes();
                            if (paramTypes.length == 0) {
                                Principal p = (Principal)constructor.newInstance(new Object[0]);
                                Method m = clazz.getMethod("setName", String.class);
                                m.invoke((Object)p, principalName);
                                return p;
                            }
                            if (paramTypes[0] != String.class) continue;
                            Object[] params = new Object[paramTypes.length];
                            params[0] = principalName;
                            return (Principal)constructor.newInstance(params);
                        }
                        throw new RuntimeException("Could not construct principal of class: " + className);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            if (e.getException() != null) {
                log.info("PrivilegedActionException containing", (Throwable)e.getException());
            } else {
                log.info("PrivilegedActionException", (Throwable)e);
            }
            return null;
        }
    }

    public static RealmPrincipal generateRealmPrincipal(String realm, String loginDomain, PrincipalInfo principalInfo, Bundle bundle) {
        return ConfigurationUtil.generateRealmPrincipal(realm, loginDomain, principalInfo.getClassName(), principalInfo.getPrincipalName(), bundle);
    }

    public static RealmPrincipal generateRealmPrincipal(String realm, String loginDomain, String className, String principalName, Bundle bundle) {
        return new RealmPrincipal(realm, loginDomain, ConfigurationUtil.generatePrincipal(className, principalName, bundle));
    }

    public static DomainPrincipal generateDomainPrincipal(String loginDomain, PrincipalInfo principalInfo, Bundle bundle) {
        return ConfigurationUtil.generateDomainPrincipal(loginDomain, principalInfo.getClassName(), principalInfo.getPrincipalName(), bundle);
    }

    public static DomainPrincipal generateDomainPrincipal(String loginDomain, String className, String principalName, Bundle bundle) {
        return new DomainPrincipal(loginDomain, ConfigurationUtil.generatePrincipal(className, principalName, bundle));
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(String realm, String domain, PrincipalInfo principalInfo, Bundle bundle) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryRealmPrincipal(realm, domain, principalInfo.getClassName(), principalInfo.getPrincipalName(), bundle);
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(final String realm, final String domain, final String className, final String principalName, final Bundle bundle) throws DeploymentException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<PrimaryRealmPrincipal>(){

                @Override
                public PrimaryRealmPrincipal run() throws Exception {
                    Principal p = null;
                    Class clazz = bundle.loadClass(className);
                    Constructor constructor = clazz.getDeclaredConstructor(String.class);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryRealmPrincipal(realm, domain, p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create realm principal", (Throwable)pae.getException());
        }
    }

    public static PrimaryDomainPrincipal generatePrimaryDomainPrincipal(String domain, PrincipalInfo principalInfo, Bundle bundle) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryDomainPrincipal(domain, principalInfo.getClassName(), principalInfo.getPrincipalName(), bundle);
    }

    public static PrimaryDomainPrincipal generatePrimaryDomainPrincipal(final String domain, final String className, final String principalName, final Bundle bundle) throws DeploymentException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<PrimaryDomainPrincipal>(){

                @Override
                public PrimaryDomainPrincipal run() throws Exception {
                    Principal p = null;
                    Class clazz = bundle.loadClass(className);
                    Constructor constructor = clazz.getDeclaredConstructor(String.class);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryDomainPrincipal(domain, p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create domain principal", (Throwable)pae.getException());
        }
    }

    public static PrimaryPrincipal generatePrimaryPrincipal(PrincipalInfo principalInfo, Bundle bundle) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryPrincipal(principalInfo.getClassName(), principalInfo.getPrincipalName(), bundle);
    }

    public static PrimaryPrincipal generatePrimaryPrincipal(final String className, final String principalName, final Bundle bundle) throws DeploymentException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<PrimaryPrincipal>(){

                @Override
                public PrimaryPrincipal run() throws Exception {
                    Principal p = null;
                    Class clazz = bundle.loadClass(className);
                    Constructor constructor = clazz.getDeclaredConstructor(String.class);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryPrincipal(p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create principal", (Throwable)pae.getException());
        }
    }

    public static void registerPolicyContextHandler(PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        for (String key : handler.getKeys()) {
            PolicyContext.registerHandler((String)key, (PolicyContextHandler)handler, (boolean)replace);
        }
    }
}

