/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.management.NotificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MBeanGBeanBridge
implements MBeanRegistration,
DynamicMBean,
NotificationEmitter {
    private static final Logger log = LoggerFactory.getLogger(MBeanGBeanBridge.class);
    private final Kernel kernel;
    private final AbstractName abstractName;
    private final ObjectName objectName;
    private final AbstractNameQuery pattern;
    private final MBeanInfo mbeanInfo;
    private final NotificationBroadcasterSupport notificationBroadcaster = new NotificationBroadcasterSupport();
    private final LifecycleBridge lifecycleBridge;

    public MBeanGBeanBridge(Kernel kernel, AbstractName abstractName, ObjectName objectName, MBeanInfo mbeanInfo) {
        this.kernel = kernel;
        this.abstractName = abstractName;
        this.pattern = new AbstractNameQuery(abstractName);
        this.mbeanInfo = mbeanInfo;
        this.objectName = objectName;
        this.lifecycleBridge = new LifecycleBridge(abstractName, objectName, this.notificationBroadcaster);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public NotificationBroadcasterSupport getNotificationBroadcasterSupport() {
        return this.notificationBroadcaster;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
        if (Boolean.TRUE.equals(registrationDone)) {
            this.kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)this.lifecycleBridge, this.pattern);
            this.lifecycleBridge.loaded(this.abstractName);
        }
    }

    public void preDeregister() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener((LifecycleListener)this.lifecycleBridge);
        this.lifecycleBridge.unloaded(this.abstractName);
    }

    public void postDeregister() {
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    public Object getAttribute(String attributeName) throws ReflectionException, AttributeNotFoundException {
        try {
            return this.kernel.getAttribute(this.abstractName, attributeName);
        }
        catch (NoSuchAttributeException e) {
            throw (AttributeNotFoundException)new AttributeNotFoundException(attributeName).initCause(e);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws ReflectionException, AttributeNotFoundException {
        String attributeName = attribute.getName();
        Object attributeValue = attribute.getValue();
        try {
            this.kernel.setAttribute(this.abstractName, attributeName, attributeValue);
        }
        catch (NoSuchAttributeException e) {
            throw (AttributeNotFoundException)new AttributeNotFoundException(attributeName).initCause(e);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList results = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            try {
                Object value = this.getAttribute(name);
                results.add(new Attribute(name, value));
                continue;
            }
            catch (JMException e) {
                log.warn("Exception while getting attribute " + name, (Throwable)e);
            }
        }
        return results;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList results = new AttributeList(attributes.size());
        for (Attribute attribute : attributes) {
            try {
                this.setAttribute(attribute);
                results.add(attribute);
            }
            catch (JMException e) {
                log.warn("Exception while setting attribute " + attribute.getName(), (Throwable)e);
            }
        }
        return results;
    }

    public Object invoke(String operationName, Object[] arguments, String[] types) throws ReflectionException {
        try {
            return this.kernel.invoke(this.abstractName, operationName, arguments, types);
        }
        catch (NoSuchOperationException e) {
            throw new ReflectionException((NoSuchMethodException)new NoSuchMethodException(new GOperationSignature(operationName, types).toString()).initCause(e));
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(NotificationType.TYPES, "javax.management.Notification", "J2EE Notifications")};
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notificationBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    public String toString() {
        return this.abstractName.toString();
    }

    private static class LifecycleBridge
    implements LifecycleListener {
        private long sequence;
        private final AbstractName mbeanAbstractName;
        private final ObjectName objectName;
        private final NotificationBroadcasterSupport notificationBroadcaster;

        public LifecycleBridge(AbstractName mbeanAbstractName, ObjectName objectName, NotificationBroadcasterSupport notificationBroadcaster) {
            this.mbeanAbstractName = mbeanAbstractName;
            this.objectName = objectName;
            this.notificationBroadcaster = notificationBroadcaster;
        }

        public void loaded(AbstractName abstractName) {
            if (this.mbeanAbstractName.equals((Object)abstractName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.object.created", this.objectName, this.nextSequence()));
            }
        }

        public void starting(AbstractName abstractName) {
            if (this.mbeanAbstractName.equals((Object)abstractName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.starting", this.objectName, this.nextSequence()));
            }
        }

        public void running(AbstractName abstractName) {
            if (this.mbeanAbstractName.equals((Object)abstractName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.running", this.objectName, this.nextSequence()));
            }
        }

        public void stopping(AbstractName abstractName) {
            if (this.mbeanAbstractName.equals((Object)abstractName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.stopping", this.objectName, this.nextSequence()));
            }
        }

        public void stopped(AbstractName abstractName) {
            if (this.mbeanAbstractName.equals((Object)abstractName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.stopped", this.objectName, this.nextSequence()));
            }
        }

        public void failed(AbstractName abstractName) {
            if (this.mbeanAbstractName.equals((Object)abstractName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.failed", this.objectName, this.nextSequence()));
            }
        }

        public void unloaded(AbstractName abstractName) {
            if (this.mbeanAbstractName.equals((Object)abstractName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.object.deleted", this.objectName, this.nextSequence()));
            }
        }

        public synchronized long nextSequence() {
            return this.sequence++;
        }
    }
}

