/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupMonitorUtil {
    private static final Logger log = LoggerFactory.getLogger(StartupMonitorUtil.class);

    public static synchronized void wrapUp(PrintStream out, Kernel kernel) {
        ArrayList<String> apps = new ArrayList<String>();
        ArrayList<String> webs = new ArrayList<String>();
        ArrayList<AddressHolder> ports = new ArrayList<AddressHolder>();
        HashMap<AbstractName, String> failed = new HashMap<AbstractName, String>();
        String serverInfo = null;
        try {
            Set gbeans = kernel.listGBeans((AbstractNameQuery)null);
            HashMap beanInfos = new HashMap();
            for (AbstractName name : gbeans) {
                ArrayList<GAttributeInfo> list;
                int stateValue;
                if (StartupMonitorUtil.isApplicationModule(name)) {
                    apps.add("    " + StartupMonitorUtil.decodeModule(name.getNameProperty("j2eeType")) + ": " + name.getNameProperty("name"));
                }
                if (StartupMonitorUtil.isWebModule(name)) {
                    webs.add(kernel.getAttribute(name, "contextPath").toString());
                }
                if ((stateValue = kernel.getGBeanState(name)) != 1) {
                    GBeanData data = kernel.getGBeanData(name);
                    State state = State.fromInt((int)stateValue);
                    StringBuilder buf = new StringBuilder();
                    buf.append("(").append(state.getName());
                    if (data != null && data.getAttributes() != null) {
                        Map map = data.getAttributes();
                        for (String att : map.keySet()) {
                            if (!att.equals("port") && att.indexOf("Port") <= -1) continue;
                            buf.append(",").append(att).append("=").append(map.get(att));
                        }
                    }
                    buf.append(")");
                    failed.put(name, buf.toString());
                    continue;
                }
                GBeanInfo info = kernel.getGBeanInfo(name);
                if (info.getClassName().equals("org.apache.geronimo.system.serverinfo.ServerInfo")) {
                    serverInfo = (String)kernel.getAttribute(name, "version");
                }
                if ((list = (ArrayList<GAttributeInfo>)beanInfos.get(info)) == null) {
                    list = new ArrayList<GAttributeInfo>(3);
                    beanInfos.put(info, list);
                    Set atts = info.getAttributes();
                    for (GAttributeInfo att : atts) {
                        if (!att.getType().equals("java.net.InetSocketAddress")) continue;
                        list.add(att);
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    GAttributeInfo att = (GAttributeInfo)list.get(i);
                    try {
                        InetSocketAddress addr = (InetSocketAddress)kernel.getAttribute(name, att.getName());
                        if (addr == null) {
                            log.debug("No value for GBean " + name + " attribute " + att.getName());
                            continue;
                        }
                        if (addr.getAddress() == null || addr.getAddress().getHostAddress() == null) {
                            log.debug("Null address or host for GBean " + name + " " + att.getName() + ": " + addr.getAddress());
                        }
                        String attName = info.getName();
                        if (list.size() > 1) {
                            attName = attName + " " + StartupMonitorUtil.decamelize(att.getName());
                        } else if (info.getAttribute("name") != null) {
                            attName = attName + " " + kernel.getAttribute(name, "name");
                        }
                        ports.add(new AddressHolder(attName, addr));
                        continue;
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(apps);
        if (ports.size() > 0) {
            AddressHolder holder;
            int i;
            Collections.sort(ports);
            System.out.println("  Listening on Ports:");
            int max = 0;
            for (i = 0; i < ports.size(); ++i) {
                holder = (AddressHolder)ports.get(i);
                if (holder.getAddress().getAddress() == null || holder.getAddress().getAddress().getHostAddress() == null) continue;
                max = Math.max(max, holder.getAddress().getAddress().getHostAddress().length());
            }
            for (i = 0; i < ports.size(); ++i) {
                holder = (AddressHolder)ports.get(i);
                StringBuilder buf = new StringBuilder();
                buf.append("   ");
                if (holder.getAddress().getPort() < 10) {
                    buf.append(' ');
                }
                if (holder.getAddress().getPort() < 100) {
                    buf.append(' ');
                }
                if (holder.getAddress().getPort() < 1000) {
                    buf.append(' ');
                }
                if (holder.getAddress().getPort() < 10000) {
                    buf.append(' ');
                }
                buf.append(holder.getAddress().getPort()).append(' ');
                String address = holder.getAddress().getAddress() == null || holder.getAddress().getAddress().getHostAddress() == null ? "" : holder.getAddress().getAddress().getHostAddress();
                buf.append(address);
                for (int j = address.length(); j <= max; ++j) {
                    buf.append(' ');
                }
                buf.append(holder.getName());
                out.println(buf.toString());
            }
            out.println();
        }
        if (apps.size() > 0) {
            out.println("  Started Application Modules:");
            for (int i = 0; i < apps.size(); ++i) {
                out.println((String)apps.get(i));
            }
            out.println();
        }
        if (webs.size() > 0) {
            Collections.sort(webs);
            out.println("  Web Applications:");
            for (int i = 0; i < webs.size(); ++i) {
                out.println("    " + webs.get(i));
            }
            out.println();
        }
        if (failed.size() > 0) {
            out.println("  WARNING: Some GBeans were not started successfully:");
            for (AbstractName name : failed.keySet()) {
                String state = (String)failed.get(name);
                if (name.getNameProperty("name") != null) {
                    log.debug("Unable to start " + name + " " + state);
                    out.println("    " + name.getNameProperty("name") + " " + state);
                    continue;
                }
                out.println("    " + name + " " + state);
            }
            out.println();
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Geronimo Application Server started");
        if (serverInfo != null) {
            msg.append(" (version ").append(serverInfo).append(")");
        }
        out.println(msg.toString());
        out.flush();
    }

    private static boolean isApplicationModule(AbstractName abstractName) {
        String type = abstractName.getNameProperty("j2eeType");
        String app = abstractName.getNameProperty("J2EEApplication");
        String name = abstractName.getNameProperty("name");
        if (type != null && (app == null || app.equals("null"))) {
            return (type.equals("WebModule") || type.equals("J2EEApplication") || type.equals("EJBModule") || type.equals("AppClientModule") || type.equals("ResourceAdapterModule")) && !name.startsWith("geronimo/system");
        }
        return false;
    }

    private static boolean isWebModule(AbstractName abstractName) {
        String type = abstractName.getNameProperty("j2eeType");
        return type != null && type.equals("WebModule");
    }

    private static String decodeModule(String value) {
        if (value.equals("WebModule")) {
            return "WAR";
        }
        if (value.equals("J2EEApplication")) {
            return "EAR";
        }
        if (value.equals("EJBModule")) {
            return "JAR";
        }
        if (value.equals("AppClientModule")) {
            return "CAR";
        }
        if (value.equals("ResourceAdapterModule")) {
            return "RAR";
        }
        return "UNK";
    }

    private static String decamelize(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(Character.toUpperCase(s.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i)) && s.length() > i + 1 && Character.isLowerCase(s.charAt(i + 1))) {
                buf.append(" ");
            }
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    private static class AddressHolder
    implements Comparable {
        private String name;
        private InetSocketAddress address;

        public AddressHolder(String name, InetSocketAddress address) {
            this.name = name;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public void setAddress(InetSocketAddress address) {
            this.address = address;
        }

        public int compareTo(Object o) {
            AddressHolder other = (AddressHolder)o;
            int value = this.address.getPort() - other.address.getPort();
            return value == 0 ? this.address.getAddress().toString().compareTo(other.address.getAddress().toString()) : value;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.getClass().getSimpleName() + ":");
            buf.append(" name=").append(this.name);
            buf.append(", address=").append(this.address.toString());
            return buf.toString();
        }
    }
}

