/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.properties;

import java.security.Provider;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmVendor {
    private static final Logger log = LoggerFactory.getLogger(JvmVendor.class);
    private static final String JVM_VENDOR_PROPERTY_NAME = "java.vm.vendor";
    private static final boolean sun;
    private static final boolean ibm;
    private static final boolean apache;
    private static final boolean ibmHybrid;

    private JvmVendor() {
    }

    public static String getFullName() {
        return System.getProperty(JVM_VENDOR_PROPERTY_NAME);
    }

    public static boolean isSun() {
        return sun;
    }

    public static boolean isIBM() {
        return ibm;
    }

    public static boolean isIBMHybrid() {
        return ibmHybrid;
    }

    public static boolean isApache() {
        return apache;
    }

    public static String getJvmInfo() {
        if (sun) {
            return new String("Sun JVM " + System.getProperty("java.version"));
        }
        if (apache) {
            return new String("Apache Harmony JVM " + System.getProperty("java.version"));
        }
        if (ibm) {
            return new String("IBM JVM " + System.getProperty("java.version"));
        }
        if (ibmHybrid) {
            return new String("IBM Hybrid JVM " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
        }
        return new String("Unknown JVM detected - " + JvmVendor.getFullName());
    }

    static {
        String fullVendorName = JvmVendor.getFullName();
        boolean bApache = fullVendorName.regionMatches(true, 0, "Apache", 0, 6);
        boolean bIBM = fullVendorName.regionMatches(true, 0, "IBM", 0, 3);
        boolean bSun = !bIBM && !bApache;
        boolean bHP = fullVendorName.regionMatches(true, 0, "Hewlett", 0, 7);
        boolean bIBMHybrid = false;
        if (bSun && System.getProperty("os.name").equalsIgnoreCase("SunOS") || bHP && System.getProperty("os.name").equalsIgnoreCase("HP-UX")) {
            log.debug("Looking for the IBM Hybrid SDK Extensions");
            try {
                if (Security.getProvider("com.ibm.jsse2.IBMJSSEProvider2") == null) {
                    log.debug("Trying to load IBM JSSE2 Provider.");
                    Class<?> c = Class.forName("com.ibm.jsse2.IBMJSSEProvider2");
                    Provider p = (Provider)c.newInstance();
                    Security.addProvider(p);
                    log.debug("Loaded the IBM JSSE2 Provider");
                } else {
                    log.debug("Found the IBM JSSE2 Provider: {}", (Object)Security.getProvider("com.ibm.jsse2.IBMJSSEProvider2"));
                }
                if (Security.getProvider("IBMCertPath") == null) {
                    log.debug("No IBMCertPath provider found.");
                    throw new RuntimeException("Could not find the IBMCertPath provider.");
                }
                log.debug("Found the IBMCertPath Provider: {}", (Object)Security.getProvider("IBMCertPath"));
                if (Security.getProvider("IBMJCE") == null) {
                    log.debug("No IBMJCE provider found.");
                    throw new RuntimeException("Could not find the IBMJCE provider.");
                }
                log.debug("Found the IBMJCE Provider {}", (Object)Security.getProvider("IBMJCE"));
                System.setProperty("java.protocol.handler.pkgs", "com.ibm.net.ssl.www2.protocol");
                bSun = false;
                bApache = false;
                bIBM = true;
                bIBMHybrid = true;
            }
            catch (ClassNotFoundException e) {
                log.debug("Caught Exception: {}", (Object)e.toString());
                log.debug("Could not load the IBM JSSE Provider.  Must be using the OS provider's Java.");
            }
            catch (Throwable t) {
                log.debug("Caught Throwable: {}", (Object)t.toString());
                log.debug("Assume we could not load the IBM JSSE Provider and that we are using the OS provider's Java.");
            }
        }
        apache = bApache;
        ibm = bIBM;
        ibmHybrid = bIBMHybrid;
        sun = bSun;
        log.info(JvmVendor.getJvmInfo());
    }
}

