/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration.condition;

import org.apache.geronimo.system.configuration.condition.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaVariable {
    private static final Logger log = LoggerFactory.getLogger(JavaVariable.class);

    public String getVendor() {
        return SystemUtils.JAVA_VENDOR;
    }

    public String getVersion() {
        return SystemUtils.JAVA_VERSION;
    }

    public String getVmVendor() {
        return SystemUtils.JAVA_VM_VENDOR;
    }

    public String getVmVersion() {
        return SystemUtils.JAVA_VM_VERSION;
    }

    public boolean getIs1_1() {
        return SystemUtils.IS_JAVA_1_1;
    }

    public boolean getIs1_2() {
        return SystemUtils.IS_JAVA_1_2;
    }

    public boolean getIs1_3() {
        return SystemUtils.IS_JAVA_1_3;
    }

    public boolean getIs1_4() {
        return SystemUtils.IS_JAVA_1_4;
    }

    public boolean getIs1_5() {
        return SystemUtils.IS_JAVA_1_5;
    }

    public boolean getIs1_6() {
        return SystemUtils.IS_JAVA_1_6;
    }

    public boolean getIs1_7() {
        return SystemUtils.IS_JAVA_1_7;
    }

    public boolean getIsVersionAtLeast(float requiredVersion) {
        return SystemUtils.isJavaVersionAtLeast(requiredVersion);
    }

    public boolean getIsVersionAtLeast(int requiredVersion) {
        return SystemUtils.isJavaVersionAtLeast(requiredVersion);
    }

    public boolean getVersionMatches(String version) {
        version = version.trim();
        boolean result = false;
        if (version.endsWith("*")) {
            version = version.substring(0, version.length() - 1).trim();
            log.debug("Checking Java version is in the same group as: {}", (Object)version);
            String tmp = SystemUtils.JAVA_VERSION_TRIMMED;
            log.debug("Requested version: {}", (Object)tmp);
            log.debug("JVM version: {}", (Object)Float.valueOf(SystemUtils.JAVA_VERSION_FLOAT));
            result = tmp.startsWith(version);
        } else if (version.endsWith("+")) {
            version = version.substring(0, version.length() - 1).trim();
            log.debug("Checking Java version is greater than: {}", (Object)version);
            float tmp = Float.parseFloat(version);
            log.debug("Requested version: {}", (Object)Float.valueOf(tmp));
            log.debug("JVM version: {}", (Object)Float.valueOf(SystemUtils.JAVA_VERSION_FLOAT));
            result = tmp <= SystemUtils.JAVA_VERSION_FLOAT;
        } else {
            log.debug("Checking Java version is equal to: {}", (Object)version);
            float tmp = Float.parseFloat(version);
            log.debug("Requested version: {}", (Object)Float.valueOf(tmp));
            log.debug("JVM version: {}", (Object)Float.valueOf(SystemUtils.JAVA_VERSION_FLOAT));
            result = tmp == SystemUtils.JAVA_VERSION_FLOAT;
        }
        return result;
    }
}

