/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.CommandLine;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class LocalServer
extends CommandLine {
    public LocalServer(String bootModule, String configListLocation) throws Exception {
        this.startKernel(Artifact.create((String)bootModule));
        Runtime.getRuntime().addShutdownHook(new Thread("Geronimo shutdown thread"){

            @Override
            public void run() {
                LocalServer.this.getKernel().shutdown();
            }
        });
        List configs = this.getConfigurationList(configListLocation);
        this.loadConfigurations(configs);
    }

    @Override
    public Kernel getKernel() {
        return super.getKernel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getConfigurationList(String path) throws GBeanNotFoundException, IOException {
        ServerInfo serverInfo = (ServerInfo)this.getKernel().getGBean(ServerInfo.class);
        File configFile = serverInfo.resolve(path);
        ArrayList<Artifact> modules = new ArrayList<Artifact>();
        BufferedReader in = new BufferedReader(new FileReader(configFile));
        try {
            String artifactString;
            while ((artifactString = in.readLine()) != null) {
                if ((artifactString = artifactString.trim()).startsWith("#") || artifactString.length() <= 0) continue;
                Artifact artifact = Artifact.create((String)artifactString);
                modules.add(artifact);
            }
        }
        finally {
            in.close();
        }
        return modules;
    }
}

