/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.sftp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.TimestampAwareFileBasedHelper;
import org.apache.gobblin.util.io.SeekableFSInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.LoggerFactory;

public class SftpFsHelper
implements TimestampAwareFileBasedHelper {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(SftpFsHelper.class);
    private Session session;
    private State state;

    public SftpFsHelper(State state) {
        this.state = state;
    }

    @Deprecated
    public ChannelSftp getSftpConnection() {
        try {
            return this.getSftpChannel();
        }
        catch (SftpException e) {
            log.error("Failed to get new sftp channel", (Throwable)e);
            return null;
        }
    }

    public ChannelSftp getSftpChannel() throws SftpException {
        try {
            ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            channelSftp.connect();
            return channelSftp;
        }
        catch (JSchException e) {
            throw new SftpException(0, "Cannot open a channel to SFTP server", (Throwable)e);
        }
    }

    public ChannelExec getExecChannel(String command) throws SftpException {
        try {
            ChannelExec channelExec = (ChannelExec)this.session.openChannel("exec");
            channelExec.setCommand(command);
            channelExec.connect();
            return channelExec;
        }
        catch (JSchException e) {
            throw new SftpException(0, "Cannot open a channel to SFTP server", (Throwable)e);
        }
    }

    @Override
    public void connect() throws FileBasedHelperException {
        String privateKey = PasswordManager.getInstance((State)this.state).readPassword(this.state.getProp("source.conn.private.key"));
        String password = PasswordManager.getInstance((State)this.state).readPassword(this.state.getProp("source.conn.password"));
        String knownHosts = this.state.getProp("source.conn.known.hosts");
        String userName = this.state.getProp("source.conn.username");
        String hostName = this.state.getProp("source.conn.host");
        int port = this.state.getPropAsInt("source.conn.port", 22);
        String proxyHost = this.state.getProp("source.conn.use.proxy.url");
        int proxyPort = this.state.getPropAsInt("source.conn.use.proxy.port", -1);
        JSch.setLogger((Logger)new JSchLogger());
        JSch jsch = new JSch();
        log.info("Attempting to connect to source via SFTP with privateKey: " + privateKey + " knownHosts: " + knownHosts + " userName: " + userName + " hostName: " + hostName + " port: " + port + " proxyHost: " + proxyHost + " proxyPort: " + proxyPort);
        try {
            if (!Strings.isNullOrEmpty((String)privateKey)) {
                IdentityStrategy identityStrategy;
                ImmutableList identityStrategies = ImmutableList.of((Object)new LocalFileIdentityStrategy(), (Object)new DistributedCacheIdentityStrategy(), (Object)new HDFSIdentityStrategy());
                Iterator iterator = identityStrategies.iterator();
                while (iterator.hasNext() && !(identityStrategy = (IdentityStrategy)iterator.next()).setIdentity(privateKey, jsch)) {
                }
            }
            this.session = jsch.getSession(userName, hostName, port);
            this.session.setConfig("PreferredAuthentications", "publickey,password");
            if (Strings.isNullOrEmpty((String)knownHosts)) {
                log.info("Known hosts path is not set, StrictHostKeyChecking will be turned off");
                this.session.setConfig("StrictHostKeyChecking", "no");
            } else {
                jsch.setKnownHosts(knownHosts);
            }
            if (!Strings.isNullOrEmpty((String)password)) {
                this.session.setPassword(password);
            }
            if (proxyHost != null && proxyPort >= 0) {
                this.session.setProxy((Proxy)new ProxyHTTP(proxyHost, proxyPort));
            }
            MyUserInfo ui = new MyUserInfo();
            this.session.setUserInfo((UserInfo)ui);
            this.session.setDaemonThread(true);
            this.session.connect();
            log.info("Finished connecting to source");
        }
        catch (JSchException e) {
            if (this.session != null) {
                this.session.disconnect();
            }
            log.error(e.getMessage(), (Throwable)e);
            throw new FileBasedHelperException("Cannot connect to SFTP source", (Exception)((Object)e));
        }
    }

    @Override
    public InputStream getFileStream(String file) throws FileBasedHelperException {
        SftpGetMonitor monitor = new SftpGetMonitor();
        try {
            ChannelSftp channel = this.getSftpChannel();
            return new SftpFsFileInputStream(channel.get(file, (SftpProgressMonitor)monitor), (Channel)channel);
        }
        catch (SftpException e) {
            throw new FileBasedHelperException("Cannot download file " + file + " due to " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public List<String> ls(String path) throws FileBasedHelperException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            ChannelSftp channel = this.getSftpChannel();
            Vector vector = channel.ls(path);
            for (ChannelSftp.LsEntry entry : vector) {
                list.add(entry.getFilename());
            }
            channel.disconnect();
            return list;
        }
        catch (SftpException e) {
            throw new FileBasedHelperException("Cannot execute ls command on sftp connection", (Exception)((Object)e));
        }
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    @Override
    public long getFileSize(String filePath) throws FileBasedHelperException {
        try {
            ChannelSftp channelSftp = this.getSftpChannel();
            long fileSize = channelSftp.lstat(filePath).getSize();
            channelSftp.disconnect();
            return fileSize;
        }
        catch (SftpException e) {
            throw new FileBasedHelperException(String.format("Failed to get size for file at path %s due to error %s", filePath, e.getMessage()), (Exception)((Object)e));
        }
    }

    @Override
    public long getFileMTime(String filePath) throws FileBasedHelperException {
        ChannelSftp channelSftp = null;
        try {
            channelSftp = this.getSftpChannel();
            int modificationTime = channelSftp.lstat(filePath).getMTime();
            long l = modificationTime;
            return l;
        }
        catch (SftpException e) {
            throw new FileBasedHelperException(String.format("Failed to get modified timestamp for file at path %s due to error %s", filePath, e.getMessage()), (Exception)((Object)e));
        }
        finally {
            if (channelSftp != null) {
                channelSftp.disconnect();
            }
        }
    }

    static class SftpFsFileInputStream
    extends SeekableFSInputStream {
        private final Channel channel;

        public SftpFsFileInputStream(InputStream in, Channel channel) {
            super(in);
            this.channel = channel;
        }

        public void close() throws IOException {
            super.close();
            this.channel.disconnect();
        }
    }

    private static class DistributedCacheIdentityStrategy
    extends LocalFileIdentityStrategy {
        private DistributedCacheIdentityStrategy() {
        }

        @Override
        public boolean setIdentity(String privateKey, JSch jsch) {
            return super.setIdentity(new File(privateKey).getName(), jsch);
        }
    }

    private static class LocalFileIdentityStrategy
    implements IdentityStrategy {
        private LocalFileIdentityStrategy() {
        }

        @Override
        public boolean setIdentity(String privateKey, JSch jsch) {
            try {
                jsch.addIdentity(privateKey);
                log.info("Successfully set identity using local file " + privateKey);
                return true;
            }
            catch (Exception e) {
                log.warn("Failed to set identity using local file. Will attempt next strategy. " + e.getMessage());
                return false;
            }
        }
    }

    private static class HDFSIdentityStrategy
    implements IdentityStrategy {
        private HDFSIdentityStrategy() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setIdentity(String privateKey, JSch jsch) {
            FileSystem fs;
            try {
                fs = FileSystem.get((Configuration)new Configuration());
            }
            catch (Exception e) {
                log.warn("Failed to set identity using HDFS file. Will attempt next strategy. " + e.getMessage());
                return false;
            }
            Preconditions.checkNotNull((Object)fs, (Object)"FileSystem cannot be null");
            try (FSDataInputStream privateKeyStream = fs.open(new Path(privateKey));){
                byte[] bytes = IOUtils.toByteArray((InputStream)privateKeyStream);
                jsch.addIdentity("sftpIdentityKey", bytes, (byte[])null, (byte[])null);
                log.info("Successfully set identity using HDFS file");
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.warn("Failed to set identity using HDFS file. Will attempt next strategy. " + e.getMessage());
                return false;
            }
        }
    }

    private static interface IdentityStrategy {
        public boolean setIdentity(String var1, JSch var2);
    }

    public static class MyUserInfo
    implements UserInfo {
        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return true;
        }

        public void showMessage(String message) {
            log.info(message);
        }
    }

    public static class JSchLogger
    implements Logger {
        public boolean isEnabled(int level) {
            switch (level) {
                case 0: {
                    return log.isDebugEnabled();
                }
                case 1: {
                    return log.isInfoEnabled();
                }
                case 2: {
                    return log.isWarnEnabled();
                }
                case 3: {
                    return log.isErrorEnabled();
                }
                case 4: {
                    return log.isErrorEnabled();
                }
            }
            return false;
        }

        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    log.debug(message);
                    break;
                }
                case 1: {
                    log.info(message);
                    break;
                }
                case 2: {
                    log.warn(message);
                    break;
                }
                case 3: {
                    log.error(message);
                    break;
                }
                case 4: {
                    log.error(message);
                    break;
                }
                default: {
                    log.info(message);
                }
            }
        }
    }

    public static class SftpGetMonitor
    implements SftpProgressMonitor {
        private int op;
        private String src;
        private String dest;
        private long totalCount;
        private long logFrequency;
        private long startime;

        public void init(int op, String src, String dest, long max) {
            this.op = op;
            this.src = src;
            this.dest = dest;
            this.startime = System.currentTimeMillis();
            this.logFrequency = 0L;
            log.info("Operation GET (" + op + ") has started with src: " + src + " dest: " + dest + " and file length: " + max / 1000000L + " mb");
        }

        public boolean count(long count) {
            this.totalCount += count;
            if (this.logFrequency == 0L) {
                this.logFrequency = 1000L;
                log.info("Transfer is in progress for file: " + this.src + ". Finished transferring " + this.totalCount + " bytes ");
                long mb = this.totalCount / 1000000L;
                log.info("Transferd " + mb + " Mb. Speed " + this.getMbps() + " Mbps");
            }
            --this.logFrequency;
            return true;
        }

        public void end() {
            long secs = (System.currentTimeMillis() - this.startime) / 1000L;
            log.info("Transfer finished " + this.op + " src: " + this.src + " dest: " + this.dest + " in " + secs + " at " + this.getMbps());
        }

        private String getMbps() {
            long mb = this.totalCount / 1000000L;
            long secs = (System.currentTimeMillis() - this.startime) / 1000L;
            double mbps = secs == 0L ? 0.0 : (double)mb * 1.0 / (double)secs;
            return String.format("%.2f", mbps);
        }
    }
}

