/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.filebased;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.source.extractor.filebased.FileBasedExtractor;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.FileDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPFileDownloader<D>
extends FileDownloader<D> {
    private static final Logger log = LoggerFactory.getLogger(GZIPFileDownloader.class);

    public GZIPFileDownloader(FileBasedExtractor<?, ?> fileBasedExtractor) {
        super(fileBasedExtractor);
    }

    @Override
    public Iterator<D> downloadFile(String file) throws IOException {
        log.info("Beginning to download gzip compressed file: " + file);
        try {
            InputStream inputStream = (InputStream)this.fileBasedExtractor.getCloser().register((Closeable)this.fileBasedExtractor.getFsHelper().getFileStream(file));
            LineIterator fileItr = IOUtils.lineIterator((InputStream)new GZIPInputStream(inputStream), (Charset)ConfigurationKeys.DEFAULT_CHARSET_ENCODING);
            if (this.fileBasedExtractor.isShouldSkipFirstRecord() && fileItr.hasNext()) {
                fileItr.next();
            }
            return fileItr;
        }
        catch (FileBasedHelperException e) {
            throw new IOException("Exception while downloading file " + file + " with message " + e.getMessage(), e);
        }
    }
}

