/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.async;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.net.Request;

public class AsyncRequest<D, RQ>
implements Request<RQ> {
    protected RQ rawRequest;
    protected final List<Thunk<D>> thunks = new ArrayList<Thunk<D>>();

    public int getRecordCount() {
        return this.thunks.size();
    }

    public long getBytesWritten() {
        long bytesWritten = 0L;
        for (Thunk<D> thunk : this.thunks) {
            bytesWritten += (long)thunk.sizeInBytes;
        }
        return bytesWritten;
    }

    public List<Thunk<D>> getThunks() {
        return ImmutableList.copyOf(this.thunks);
    }

    public void markRecord(BufferedRecord<D> record, int bytesWritten) {
        this.thunks.add(new Thunk<D>(record, bytesWritten));
    }

    @Override
    public RQ getRawRequest() {
        return this.rawRequest;
    }

    public void setRawRequest(RQ rawRequest) {
        this.rawRequest = rawRequest;
    }

    public static final class Thunk<D> {
        @Deprecated
        public final Callback callback;
        public final int sizeInBytes;
        public final BufferedRecord<D> record;

        @Deprecated
        Thunk(Callback callback, int sizeInBytes) {
            this.callback = callback;
            this.sizeInBytes = sizeInBytes;
            this.record = null;
        }

        Thunk(BufferedRecord<D> record, int sizeInBytes) {
            this.callback = record.getCallback();
            this.sizeInBytes = sizeInBytes;
            this.record = record;
        }
    }
}

