/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.ToAvroConverterBase;
import org.apache.gobblin.converter.avro.JsonElementConversionFactory;
import org.apache.gobblin.converter.avro.JsonElementConversionWithAvroSchemaFactory;

public class JsonRecordAvroSchemaToAvroConverter<SI>
extends ToAvroConverterBase<SI, JsonObject> {
    private static final Splitter SPLITTER_ON_COMMA = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private Schema schema;
    private List<String> ignoreFields;

    public ToAvroConverterBase<SI, JsonObject> init(WorkUnitState workUnit) {
        super.init(workUnit);
        this.ignoreFields = SPLITTER_ON_COMMA.splitToList((CharSequence)workUnit.getProp("converter.ignoreFields", ""));
        return this;
    }

    public Schema convertSchema(SI inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        Preconditions.checkArgument((boolean)workUnit.contains("converter.avroSchema"));
        this.schema = new Schema.Parser().parse(workUnit.getProp("converter.avroSchema"));
        return this.schema;
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, JsonObject inputRecord, WorkUnitState workUnit) throws DataConversionException {
        GenericRecord avroRecord = JsonRecordAvroSchemaToAvroConverter.convertNestedRecord(outputSchema, inputRecord, workUnit, this.ignoreFields);
        return new SingleRecordIterable((Object)avroRecord);
    }

    public static GenericRecord convertNestedRecord(Schema outputSchema, JsonObject inputRecord, WorkUnitState workUnit, List<String> ignoreFields) throws DataConversionException {
        GenericData.Record avroRecord = new GenericData.Record(outputSchema);
        for (Schema.Field field : outputSchema.getFields()) {
            if (ignoreFields.contains(field.name())) continue;
            Schema.Type type = field.schema().getType();
            boolean nullable = false;
            Schema schema = field.schema();
            if (type.equals((Object)Schema.Type.UNION)) {
                nullable = true;
                List types = field.schema().getTypes();
                if (types.size() != 2) {
                    throw new DataConversionException("Unions must be size 2, and contain one null");
                }
                if (((Schema)field.schema().getTypes().get(0)).getType().equals((Object)Schema.Type.NULL)) {
                    schema = (Schema)field.schema().getTypes().get(1);
                    type = schema.getType();
                } else if (((Schema)field.schema().getTypes().get(1)).getType().equals((Object)Schema.Type.NULL)) {
                    schema = (Schema)field.schema().getTypes().get(0);
                    type = schema.getType();
                } else {
                    throw new DataConversionException("Unions must be size 2, and contain one null");
                }
                if (inputRecord.get(field.name()) == null) {
                    inputRecord.add(field.name(), (JsonElement)JsonNull.INSTANCE);
                }
            }
            if (inputRecord.get(field.name()) == null) {
                throw new DataConversionException("Field missing from record: " + field.name());
            }
            if (type.equals((Object)Schema.Type.RECORD)) {
                if (nullable && inputRecord.get(field.name()).isJsonNull()) {
                    avroRecord.put(field.name(), null);
                    continue;
                }
                avroRecord.put(field.name(), (Object)JsonRecordAvroSchemaToAvroConverter.convertNestedRecord(schema, inputRecord.get(field.name()).getAsJsonObject(), workUnit, ignoreFields));
                continue;
            }
            try {
                JsonElementConversionFactory.JsonElementConverter converter = JsonElementConversionWithAvroSchemaFactory.getConvertor(field.name(), type.getName(), schema, workUnit, nullable, ignoreFields);
                avroRecord.put(field.name(), converter.convert(inputRecord.get(field.name())));
            }
            catch (Exception e) {
                throw new DataConversionException("Could not convert field " + field.name(), (Throwable)e);
            }
        }
        return avroRecord;
    }
}

