/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.csv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvToJsonConverterV2
extends Converter<String, JsonArray, String[], JsonObject> {
    private static final Logger LOG = LoggerFactory.getLogger(CsvToJsonConverterV2.class);
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final String COLUMN_NAME_KEY = "columnName";
    private static final String DATA_TYPE_KEY = "dataType";
    private static final String TYPE = "type";
    private static final String JSON_NULL_VAL = "null";
    public static final String CUSTOM_ORDERING = "converter.csv_to_json.custom_order";
    private List<String> customOrder;

    public Converter<String, JsonArray, String[], JsonObject> init(WorkUnitState workUnit) {
        super.init(workUnit);
        this.customOrder = workUnit.getPropAsList(CUSTOM_ORDERING, "");
        if (!this.customOrder.isEmpty()) {
            LOG.info("Will use custom order to generate JSON from CSV: " + this.customOrder);
        }
        return this;
    }

    public JsonArray convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        Preconditions.checkNotNull((Object)inputSchema, (Object)"inputSchema is required.");
        return JSON_PARSER.parse(inputSchema).getAsJsonArray();
    }

    public Iterable<JsonObject> convertRecord(JsonArray outputSchema, String[] inputRecord, WorkUnitState workUnit) throws DataConversionException {
        JsonObject outputRecord = null;
        outputRecord = !this.customOrder.isEmpty() ? this.createOutput(outputSchema, inputRecord, this.customOrder) : this.createOutput(outputSchema, inputRecord);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converted into " + outputRecord);
        }
        return new SingleRecordIterable((Object)outputRecord);
    }

    @VisibleForTesting
    JsonObject createOutput(JsonArray outputSchema, String[] inputRecord) {
        Preconditions.checkArgument((outputSchema.size() == inputRecord.length ? 1 : 0) != 0, (Object)("# of columns mismatch. Input " + inputRecord.length + " , output: " + outputSchema.size()));
        JsonObject outputRecord = new JsonObject();
        for (int i = 0; i < outputSchema.size(); ++i) {
            JsonObject field = outputSchema.get(i).getAsJsonObject();
            String key = field.get(COLUMN_NAME_KEY).getAsString();
            if (StringUtils.isEmpty((CharSequence)inputRecord[i]) || JSON_NULL_VAL.equalsIgnoreCase(inputRecord[i])) {
                outputRecord.add(key, (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            outputRecord.add(key, this.convertValue(inputRecord[i], field.getAsJsonObject(DATA_TYPE_KEY)));
        }
        return outputRecord;
    }

    @VisibleForTesting
    JsonObject createOutput(JsonArray outputSchema, String[] inputRecord, List<String> customOrder) {
        Preconditions.checkArgument((outputSchema.size() == customOrder.size() ? 1 : 0) != 0, (Object)("# of columns mismatch. Input " + outputSchema.size() + " , output: " + customOrder.size()));
        JsonObject outputRecord = new JsonObject();
        Iterator outputSchemaIterator = outputSchema.iterator();
        Iterator<String> customOrderIterator = customOrder.iterator();
        while (outputSchemaIterator.hasNext() && customOrderIterator.hasNext()) {
            JsonObject field = ((JsonElement)outputSchemaIterator.next()).getAsJsonObject();
            String key = field.get(COLUMN_NAME_KEY).getAsString();
            int i = Integer.parseInt(customOrderIterator.next());
            Preconditions.checkArgument((i < inputRecord.length ? 1 : 0) != 0, (Object)("Index out of bound detected in customer order. Index: " + i + " , # of CSV columns: " + inputRecord.length));
            if (i < 0 || null == inputRecord[i] || JSON_NULL_VAL.equalsIgnoreCase(inputRecord[i])) {
                outputRecord.add(key, (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            outputRecord.add(key, this.convertValue(inputRecord[i], field.getAsJsonObject(DATA_TYPE_KEY)));
        }
        return outputRecord;
    }

    private JsonElement convertValue(String value, JsonObject dataType) {
        if (dataType == null || !dataType.has(TYPE)) {
            return new JsonPrimitive(value);
        }
        String type = dataType.get(TYPE).getAsString().toUpperCase();
        ValueType valueType = ValueType.valueOf(type);
        return valueType.convert(value);
    }

    private static enum ValueType {
        INT{

            @Override
            JsonElement convert(String value) {
                return new JsonPrimitive((Number)Double.valueOf(value).intValue());
            }
        }
        ,
        LONG{

            @Override
            JsonElement convert(String value) {
                return new JsonPrimitive((Number)Double.valueOf(value).longValue());
            }
        }
        ,
        FLOAT{

            @Override
            JsonElement convert(String value) {
                return new JsonPrimitive((Number)Float.valueOf(Double.valueOf(value).floatValue()));
            }
        }
        ,
        DOUBLE{

            @Override
            JsonElement convert(String value) {
                return new JsonPrimitive((Number)Double.valueOf(value));
            }
        }
        ,
        BOOLEAN{

            @Override
            JsonElement convert(String value) {
                return new JsonPrimitive(Boolean.valueOf(value));
            }
        }
        ,
        STRING{

            @Override
            JsonElement convert(String value) {
                return new JsonPrimitive(value);
            }
        };


        abstract JsonElement convert(String var1);
    }
}

