/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.avro.JsonElementConversionFactory;
import org.apache.gobblin.converter.avro.JsonRecordAvroSchemaToAvroConverter;
import org.apache.gobblin.converter.avro.UnsupportedDateTypeException;

public class JsonElementConversionWithAvroSchemaFactory
extends JsonElementConversionFactory {
    public static JsonElementConversionFactory.JsonElementConverter getConvertor(String fieldName, String fieldType, Schema schemaNode, WorkUnitState state, boolean nullable, List<String> ignoreFields) throws UnsupportedDateTypeException {
        JsonElementConversionFactory.Type type;
        try {
            type = JsonElementConversionFactory.Type.valueOf(fieldType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedDateTypeException(fieldType + " is unsupported");
        }
        switch (type) {
            case ARRAY: {
                return new ArrayConverter(fieldName, nullable, type.toString(), schemaNode, state, ignoreFields);
            }
            case MAP: {
                return new MapConverter(fieldName, nullable, type.toString(), schemaNode, state, ignoreFields);
            }
            case ENUM: {
                return new EnumConverter(fieldName, nullable, type.toString(), schemaNode);
            }
            case RECORD: {
                return new RecordConverter(fieldName, nullable, type.toString(), schemaNode, state, ignoreFields);
            }
        }
        return JsonElementConversionFactory.getConvertor(fieldName, fieldType, new JsonObject(), state, nullable);
    }

    public static class RecordConverter
    extends JsonElementConversionFactory.ComplexConverter {
        List<String> ignoreFields;
        Schema schema;
        WorkUnitState state;

        public RecordConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode, WorkUnitState state, List<String> ignoreFields) throws UnsupportedDateTypeException {
            super(fieldName, nullable, sourceType);
            this.schema = schemaNode;
            this.state = state;
            this.ignoreFields = ignoreFields;
        }

        @Override
        Object convertField(JsonElement value) {
            try {
                return JsonRecordAvroSchemaToAvroConverter.convertNestedRecord(this.schema, value.getAsJsonObject(), this.state, this.ignoreFields);
            }
            catch (DataConversionException e) {
                throw new RuntimeException("Failed to convert nested record", e);
            }
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.RECORD;
        }

        @Override
        public Schema schema() {
            return this.schema;
        }
    }

    public static class EnumConverter
    extends JsonElementConversionFactory.JsonElementConverter {
        String enumName;
        List<String> enumSet = new ArrayList<String>();
        Schema schema;

        public EnumConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode) {
            super(fieldName, nullable, sourceType);
            this.enumSet.addAll(schemaNode.getEnumSymbols());
            this.enumName = schemaNode.getType().getName();
            this.schema = schemaNode;
        }

        @Override
        Object convertField(JsonElement value) {
            return new GenericData.EnumSymbol(this.schema, value.getAsString());
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.ENUM;
        }

        @Override
        public Schema schema() {
            this.schema = Schema.createEnum((String)this.enumName, (String)"", (String)"", this.enumSet);
            this.schema.addProp("source.type", "enum");
            return this.schema;
        }
    }

    public static class MapConverter
    extends JsonElementConversionFactory.ComplexConverter {
        public MapConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode, WorkUnitState state, List<String> ignoreFields) throws UnsupportedDateTypeException {
            super(fieldName, nullable, sourceType);
            super.setElementConverter(JsonElementConversionWithAvroSchemaFactory.getConvertor(fieldName, schemaNode.getValueType().getType().getName(), schemaNode.getValueType(), state, this.isNullable(), ignoreFields));
        }

        @Override
        Object convertField(JsonElement value) {
            HashMap map = new HashMap();
            for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                map.put(entry.getKey(), this.getElementConverter().convertField((JsonElement)entry.getValue()));
            }
            return map;
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.MAP;
        }

        @Override
        public Schema schema() {
            Schema schema = Schema.createMap((Schema)this.getElementConverter().schema());
            schema.addProp("source.type", "map");
            return schema;
        }
    }

    public static class ArrayConverter
    extends JsonElementConversionFactory.ComplexConverter {
        public ArrayConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode, WorkUnitState state, List<String> ignoreFields) throws UnsupportedDateTypeException {
            super(fieldName, nullable, sourceType);
            super.setElementConverter(JsonElementConversionWithAvroSchemaFactory.getConvertor(fieldName, schemaNode.getElementType().getType().getName(), schemaNode.getElementType(), state, this.isNullable(), ignoreFields));
        }

        @Override
        Object convertField(JsonElement value) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement elem : (JsonArray)value) {
                list.add(this.getElementConverter().convertField(elem));
            }
            return new GenericData.Array(this.schema(), list);
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.ARRAY;
        }

        @Override
        public Schema schema() {
            Schema schema = Schema.createArray((Schema)this.getElementConverter().schema());
            schema.addProp("source.type", "array");
            return schema;
        }
    }
}

