/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.qualitychecker.row;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicy;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicyChecker;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.WriterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowLevelPolicyCheckerBuilder {
    private final State state;
    private final int index;
    private static final Logger LOG = LoggerFactory.getLogger(RowLevelPolicyCheckerBuilder.class);

    public RowLevelPolicyCheckerBuilder(State state, int index) {
        this.state = state;
        this.index = index;
    }

    private List<RowLevelPolicy> createPolicyList() throws Exception {
        ArrayList<RowLevelPolicy> list = new ArrayList<RowLevelPolicy>();
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
        String rowLevelPoliciesKey = ForkOperatorUtils.getPropertyNameForBranch((String)"qualitychecker.row.policies", (int)this.index);
        String rowLevelPolicyTypesKey = ForkOperatorUtils.getPropertyNameForBranch((String)"qualitychecker.row.policy.types", (int)this.index);
        if (this.state.contains(rowLevelPoliciesKey) && this.state.contains(rowLevelPolicyTypesKey)) {
            ArrayList policies = Lists.newArrayList((Iterable)splitter.split((CharSequence)this.state.getProp(rowLevelPoliciesKey)));
            ArrayList types = Lists.newArrayList((Iterable)splitter.split((CharSequence)this.state.getProp(rowLevelPolicyTypesKey)));
            if (policies.size() != types.size()) {
                throw new Exception("Row Policies list and Row Policies list type are not the same length");
            }
            for (int i = 0; i < policies.size(); ++i) {
                try {
                    Class<?> policyClass = Class.forName((String)policies.get(i));
                    Constructor<?> policyConstructor = policyClass.getConstructor(State.class, RowLevelPolicy.Type.class);
                    RowLevelPolicy policy = (RowLevelPolicy)policyConstructor.newInstance(this.state, RowLevelPolicy.Type.valueOf((String)((String)types.get(i))));
                    list.add(policy);
                    continue;
                }
                catch (Exception e) {
                    LOG.error(rowLevelPoliciesKey + " contains a class " + (String)policies.get(i) + " which doesn't extend RowLevelPolicy.", (Throwable)e);
                    throw e;
                }
            }
        }
        return list;
    }

    public static RowLevelPolicyCheckerBuilder newBuilder(State state, int index) {
        return new RowLevelPolicyCheckerBuilder(state, index);
    }

    public RowLevelPolicyChecker build() throws Exception {
        return new RowLevelPolicyChecker(this.createPolicyList(), this.state.getId(), WriterUtils.getWriterFS((State)this.state, (int)1, (int)0), this.state);
    }
}

