/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.gobblin.async.AsyncDataDispatcher;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.writer.AsyncDataWriter;
import org.apache.gobblin.writer.FutureWrappedWriteCallback;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;

@ThreadSafe
public abstract class AbstractAsyncDataWriter<D>
extends AsyncDataDispatcher<BufferedRecord<D>>
implements AsyncDataWriter<D> {
    public static final int DEFAULT_BUFFER_CAPACITY = 10000;

    public AbstractAsyncDataWriter(int capacity) {
        super(capacity);
    }

    public final Future<WriteResponse> write(D record, @Nullable WriteCallback callback) {
        FutureWrappedWriteCallback wrappedWriteCallback = new FutureWrappedWriteCallback(callback);
        BufferedRecord<D> bufferedRecord = new BufferedRecord<D>(record, (Callback)wrappedWriteCallback);
        this.put(bufferedRecord);
        return wrappedWriteCallback;
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.terminate();
        }
    }

    public void flush() throws IOException {
        this.waitForBufferEmpty();
    }
}

