/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.compression.CompressionConfigParser;
import org.apache.gobblin.compression.CompressionFactory;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.crypto.EncryptionConfigParser;
import org.apache.gobblin.crypto.EncryptionFactory;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.FsDataWriterBuilder;
import org.apache.gobblin.writer.MetadataWriterWrapper;
import org.apache.gobblin.writer.SimpleDataWriter;

public class SimpleDataWriterBuilder
extends FsDataWriterBuilder<String, Object> {
    public DataWriter<Object> build() throws IOException {
        return new MetadataWriterWrapper<byte[]>(new SimpleDataWriter(this, this.destination.getProperties()), byte[].class, this.branches, this.branch, this.destination.getProperties());
    }

    @Override
    protected List<StreamCodec> buildEncoders() {
        Map encryptionConfig;
        Preconditions.checkNotNull((Object)this.destination, (Object)"Destination must be set before building encoders");
        ArrayList<StreamCodec> encoders = new ArrayList<StreamCodec>();
        Map compressionConfig = CompressionConfigParser.getConfigForBranch((State)this.destination.getProperties(), (int)this.branches, (int)this.branch);
        if (compressionConfig != null) {
            encoders.add(CompressionFactory.buildStreamCompressor((Map)compressionConfig));
        }
        if ((encryptionConfig = EncryptionConfigParser.getConfigForBranch((EncryptionConfigParser.EntityType)EncryptionConfigParser.EntityType.WRITER, (State)this.destination.getProperties(), (int)this.branches, (int)this.branch)) != null) {
            encoders.add(EncryptionFactory.buildStreamCryptoProvider((Map)encryptionConfig));
        }
        return encoders;
    }
}

