/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.partitioner;

import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.partitioner.TimeBasedWriterPartitioner;

public class WorkUnitStateWriterPartitioner
extends TimeBasedWriterPartitioner<Object> {
    private final long timestamp;

    public WorkUnitStateWriterPartitioner(State state, int numBranches, int branches) {
        super(state, numBranches, branches);
        this.timestamp = this.calculateTimestamp(state);
    }

    @Override
    public long getRecordTimestamp(Object record) {
        return this.timestamp;
    }

    private long calculateTimestamp(State state) {
        long timestamp = state.getPropAsLong("workunit.source.date.partition", -1L);
        if (timestamp == -1L) {
            throw new IllegalArgumentException("WORK_UNIT_DATE_PARTITION_KEY not present in WorkUnitState; is source an instance of DatePartitionedAvroFileSource?");
        }
        return timestamp;
    }
}

