/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.math3.util.Pair;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.AvroToAvroConverterBase;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.AvroUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroRecursionEliminatingConverter
extends AvroToAvroConverterBase {
    private static final Logger log = LoggerFactory.getLogger(AvroRecursionEliminatingConverter.class);

    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        Pair results = AvroUtils.dropRecursiveFields((Schema)inputSchema);
        List recursiveFields = (List)results.getSecond();
        if (!recursiveFields.isEmpty()) {
            log.warn("Schema {} is recursive. Will drop fields [{}]", (Object)inputSchema.getFullName(), (Object)recursiveFields.stream().map(entry -> entry.getFieldName()).collect(Collectors.joining(",")));
            log.debug("Projected Schema = {}", results.getFirst());
        }
        return (Schema)results.getFirst();
    }

    public Iterable<GenericRecord> convertRecordImpl(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            return new SingleRecordIterable((Object)AvroUtils.convertRecordSchema((GenericRecord)inputRecord, (Schema)outputSchema));
        }
        catch (IOException e) {
            throw new DataConversionException("Failed to convert", (Throwable)e);
        }
    }
}

