/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.avro.JsonElementConversionFactory;
import org.apache.gobblin.converter.avro.JsonRecordAvroSchemaToAvroConverter;
import org.apache.gobblin.converter.avro.UnsupportedDateTypeException;

public class JsonElementConversionWithAvroSchemaFactory
extends JsonElementConversionFactory {
    public static JsonElementConversionFactory.JsonElementConverter getConverter(String fieldName, String fieldType, Schema schemaNode, WorkUnitState state, boolean nullable, List<String> ignoreFields) throws UnsupportedDateTypeException {
        JsonElementConversionFactory.Type type;
        try {
            type = JsonElementConversionFactory.Type.valueOf(fieldType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedDateTypeException(fieldType + " is unsupported");
        }
        switch (type) {
            case ARRAY: {
                return new ArrayConverter(fieldName, nullable, type.toString(), schemaNode, state, ignoreFields);
            }
            case MAP: {
                return new MapConverter(fieldName, nullable, type.toString(), schemaNode, state, ignoreFields);
            }
            case ENUM: {
                return new EnumConverter(fieldName, nullable, type.toString(), schemaNode);
            }
            case RECORD: {
                return new RecordConverter(fieldName, nullable, type.toString(), schemaNode, state, ignoreFields);
            }
            case UNION: {
                return new UnionConverter(fieldName, nullable, type.toString(), schemaNode, state, ignoreFields);
            }
        }
        return JsonElementConversionFactory.getConvertor(fieldName, fieldType, new JsonObject(), state, nullable);
    }

    public static class UnionConverter
    extends JsonElementConversionFactory.ComplexConverter {
        private final List<Schema> schemas;
        private final List<JsonElementConversionFactory.JsonElementConverter> converters;
        private final Schema schemaNode;

        public UnionConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode, WorkUnitState state, List<String> ignoreFields) throws UnsupportedDateTypeException {
            super(fieldName, nullable, sourceType);
            this.schemas = schemaNode.getTypes();
            this.converters = new ArrayList<JsonElementConversionFactory.JsonElementConverter>();
            for (Schema schema : this.schemas) {
                this.converters.add(JsonElementConversionWithAvroSchemaFactory.getConverter(fieldName, schema.getType().getName(), schemaNode, state, this.isNullable(), ignoreFields));
            }
            this.schemaNode = schemaNode;
        }

        @Override
        Object convertField(JsonElement value) {
            block11: for (JsonElementConversionFactory.JsonElementConverter converter : this.converters) {
                try {
                    switch (converter.getTargetType()) {
                        case STRING: {
                            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isString()) continue block11;
                            return converter.convert(value);
                        }
                        case FIXED: 
                        case BYTES: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isNumber()) continue block11;
                            return converter.convert(value);
                        }
                        case BOOLEAN: {
                            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isBoolean()) continue block11;
                            return converter.convert(value);
                        }
                        case ARRAY: {
                            if (!value.isJsonArray()) continue block11;
                            return converter.convert(value);
                        }
                        case MAP: 
                        case ENUM: 
                        case RECORD: {
                            if (!value.isJsonObject()) continue block11;
                            return converter.convert(value);
                        }
                        case NULL: {
                            if (!value.isJsonNull()) continue block11;
                            return converter.convert(value);
                        }
                        case UNION: {
                            return new UnsupportedDateTypeException("does not support union type in union");
                        }
                        default: {
                            return converter.convert(value);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
            throw new RuntimeException(String.format("Cannot convert %s to avro using schema %s", value.getAsString(), this.schemaNode.toString()));
        }

        @Override
        public Schema.Type getTargetType() {
            return this.schema().getType();
        }

        @Override
        public Schema schema() {
            if (this.schemas.size() == 2 && this.isNullable()) {
                if (this.schemas.get(0).getType() == Schema.Type.NULL) {
                    return this.schemas.get(1);
                }
                return this.schemas.get(0);
            }
            return Schema.createUnion(this.schemas);
        }

        @Override
        public boolean isNullable() {
            boolean isNullable = false;
            for (Schema schema : this.schemas) {
                if (schema.getType() != Schema.Type.NULL) continue;
                isNullable = true;
            }
            return isNullable;
        }
    }

    public static class RecordConverter
    extends JsonElementConversionFactory.ComplexConverter {
        List<String> ignoreFields;
        Schema schema;
        WorkUnitState state;

        public RecordConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode, WorkUnitState state, List<String> ignoreFields) {
            super(fieldName, nullable, sourceType);
            this.schema = schemaNode;
            this.state = state;
            this.ignoreFields = ignoreFields;
        }

        @Override
        Object convertField(JsonElement value) {
            try {
                return JsonRecordAvroSchemaToAvroConverter.convertNestedRecord(this.schema, value.getAsJsonObject(), this.state, this.ignoreFields);
            }
            catch (DataConversionException e) {
                throw new RuntimeException("Failed to convert nested record", e);
            }
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.RECORD;
        }

        @Override
        public Schema schema() {
            return this.schema;
        }
    }

    public static class EnumConverter
    extends JsonElementConversionFactory.JsonElementConverter {
        String enumName;
        List<String> enumSet = new ArrayList<String>();
        Schema schema;

        public EnumConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode) {
            super(fieldName, nullable, sourceType);
            this.enumSet.addAll(schemaNode.getEnumSymbols());
            this.enumName = schemaNode.getFullName();
            this.schema = schemaNode;
        }

        @Override
        Object convertField(JsonElement value) {
            String valueString = value.getAsString();
            Preconditions.checkArgument((boolean)this.enumSet.contains(valueString), (String)"%s is not one of the valid symbols for the %s enum: %s", (Object[])new Object[]{valueString, this.enumName, this.enumSet});
            return new GenericData.EnumSymbol(this.schema, valueString);
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.ENUM;
        }

        @Override
        public Schema schema() {
            this.schema = Schema.createEnum((String)this.enumName, (String)"", (String)"", this.enumSet);
            this.schema.addProp("source.type", "enum");
            return this.schema;
        }
    }

    public static class MapConverter
    extends JsonElementConversionFactory.ComplexConverter {
        public MapConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode, WorkUnitState state, List<String> ignoreFields) throws UnsupportedDateTypeException {
            super(fieldName, nullable, sourceType);
            super.setElementConverter(JsonElementConversionWithAvroSchemaFactory.getConverter(fieldName, schemaNode.getValueType().getType().getName(), schemaNode.getValueType(), state, this.isNullable(), ignoreFields));
        }

        @Override
        Object convertField(JsonElement value) {
            HashMap map = new HashMap();
            for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                map.put(entry.getKey(), this.getElementConverter().convert((JsonElement)entry.getValue()));
            }
            return map;
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.MAP;
        }

        @Override
        public Schema schema() {
            Schema schema = Schema.createMap((Schema)this.getElementConverter().schema());
            schema.addProp("source.type", "map");
            return schema;
        }
    }

    public static class ArrayConverter
    extends JsonElementConversionFactory.ComplexConverter {
        public ArrayConverter(String fieldName, boolean nullable, String sourceType, Schema schemaNode, WorkUnitState state, List<String> ignoreFields) throws UnsupportedDateTypeException {
            super(fieldName, nullable, sourceType);
            super.setElementConverter(JsonElementConversionWithAvroSchemaFactory.getConverter(fieldName, schemaNode.getElementType().getType().getName(), schemaNode.getElementType(), state, this.isNullable(), ignoreFields));
        }

        @Override
        Object convertField(JsonElement value) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement elem : (JsonArray)value) {
                list.add(this.getElementConverter().convert(elem));
            }
            return new GenericData.Array(this.schema(), list);
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.ARRAY;
        }

        @Override
        public Schema schema() {
            Schema schema = Schema.createArray((Schema)this.getElementConverter().schema());
            schema.addProp("source.type", "array");
            return schema;
        }
    }
}

