/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import com.typesafe.config.Config;
import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.publisher.BaseDataPublisher;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.ParallelRunner;
import org.apache.gobblin.util.WriterUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class TimePartitionedDataPublisher
extends BaseDataPublisher {
    public TimePartitionedDataPublisher(State state) throws IOException {
        super(state);
    }

    @Override
    protected void addWriterOutputToExistingDir(Path writerOutput, Path publisherOutput, WorkUnitState workUnitState, int branchId, ParallelRunner parallelRunner) throws IOException {
        for (FileStatus status : FileListUtils.listFilesRecursively((FileSystem)((FileSystem)this.writerFileSystemByBranches.get(branchId)), (Path)writerOutput)) {
            String filePathStr = status.getPath().toString();
            String pathSuffix = filePathStr.substring(filePathStr.indexOf(writerOutput.toString()) + writerOutput.toString().length() + 1);
            Path outputPath = new Path(publisherOutput, pathSuffix);
            WriterUtils.mkdirsWithRecursivePermissionWithRetry((FileSystem)((FileSystem)this.publisherFileSystemByBranches.get(branchId)), (Path)outputPath.getParent(), (FsPermission)((FsPermission)this.permissions.get(branchId)), (Config)this.retrierConfig);
            this.movePath(parallelRunner, (State)workUnitState, status.getPath(), outputPath, branchId);
        }
    }
}

