/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.gobblin.configuration.SourceState;

public interface PartitionAwareFileRetriever {
    public void init(SourceState var1);

    public long getWatermarkFromString(String var1);

    public long getWatermarkIncrementMs();

    public List<FileInfo> getFilesToProcess(long var1, int var3) throws IOException;

    public static class FileInfo
    implements Comparable<FileInfo> {
        private final String filePath;
        private final long fileSize;
        private final long watermarkMsSinceEpoch;
        private final String partitionName;

        public FileInfo(String filePath, long fileSize, long watermarkMsSinceEpoch, String partitionName) {
            this.fileSize = fileSize;
            this.filePath = filePath;
            this.watermarkMsSinceEpoch = watermarkMsSinceEpoch;
            this.partitionName = partitionName;
        }

        public FileInfo(String filePath, long fileSize, long watermarkMsSinceEpoch) {
            this(filePath, fileSize, watermarkMsSinceEpoch, Long.toString(watermarkMsSinceEpoch));
        }

        public String getFilePath() {
            return this.filePath;
        }

        public long getWatermarkMsSinceEpoch() {
            return this.watermarkMsSinceEpoch;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public String toString() {
            return "FileInfo{filePath='" + this.filePath + '\'' + ", watermarkMsSinceEpoch=" + this.watermarkMsSinceEpoch + ", partitionName=" + this.partitionName + '}';
        }

        @Override
        public int compareTo(FileInfo o) {
            if (this.watermarkMsSinceEpoch < o.watermarkMsSinceEpoch) {
                return -1;
            }
            if (this.watermarkMsSinceEpoch > o.watermarkMsSinceEpoch) {
                return 1;
            }
            int ret = this.filePath.compareTo(o.filePath);
            return ret == 0 ? this.partitionName.compareTo(o.partitionName) : ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            return this.fileSize == fileInfo.fileSize && this.watermarkMsSinceEpoch == fileInfo.watermarkMsSinceEpoch && Objects.equals(this.filePath, fileInfo.filePath) && Objects.equals(this.partitionName, fileInfo.partitionName);
        }

        public int hashCode() {
            return Objects.hash(this.filePath, this.fileSize, this.watermarkMsSinceEpoch, this.partitionName);
        }
    }
}

