/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.workunit;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;

public class MultiWorkUnitWeightedQueue {
    private final Queue<WeightedMultiWorkUnit> weightedWorkUnitQueue;
    private int maxMultiWorkUnits = Integer.MAX_VALUE;
    private int numMultiWorkUnits = 0;

    public MultiWorkUnitWeightedQueue() {
        this.weightedWorkUnitQueue = new PriorityQueue<WeightedMultiWorkUnit>();
    }

    public MultiWorkUnitWeightedQueue(int maxMultiWorkUnits) {
        this.weightedWorkUnitQueue = new PriorityQueue<WeightedMultiWorkUnit>(maxMultiWorkUnits);
        this.maxMultiWorkUnits = maxMultiWorkUnits;
    }

    public void addWorkUnit(WorkUnit workUnit, long weight) {
        WeightedMultiWorkUnit weightMultiWorkUnit;
        if (this.numMultiWorkUnits < this.maxMultiWorkUnits) {
            weightMultiWorkUnit = new WeightedMultiWorkUnit();
            ++this.numMultiWorkUnits;
        } else {
            weightMultiWorkUnit = this.weightedWorkUnitQueue.poll();
        }
        weightMultiWorkUnit.addWorkUnit(weight, workUnit);
        this.weightedWorkUnitQueue.offer(weightMultiWorkUnit);
    }

    public List<WorkUnit> getQueueAsList() {
        return ImmutableList.builder().addAll(this.weightedWorkUnitQueue).build();
    }

    private static class WeightedMultiWorkUnit
    extends MultiWorkUnit
    implements Comparable<WeightedMultiWorkUnit> {
        private long weight = 0L;

        private WeightedMultiWorkUnit() {
        }

        private void addWorkUnit(long weight, WorkUnit newWorkUnit) {
            this.addWorkUnit(newWorkUnit);
            this.weight += weight;
        }

        @Override
        public int compareTo(WeightedMultiWorkUnit weightedMultiWorkUnit) {
            return Longs.compare((long)this.weight, (long)weightedMultiWorkUnit.getWeight());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.weight ^ this.weight >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WeightedMultiWorkUnit)) {
                return false;
            }
            WeightedMultiWorkUnit weightedMultiWorkUnit = (WeightedMultiWorkUnit)obj;
            return this.weight == weightedMultiWorkUnit.getWeight();
        }

        public long getWeight() {
            return this.weight;
        }
    }
}

