/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.FsDataWriter;
import org.apache.gobblin.writer.HiveWritableHdfsDataWriterBuilder;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;

public class HiveWritableHdfsDataWriter
extends FsDataWriter<Writable> {
    protected FileSinkOperator.RecordWriter writer;
    protected final AtomicLong count = new AtomicLong(0L);
    private boolean closed = false;

    public HiveWritableHdfsDataWriter(HiveWritableHdfsDataWriterBuilder<?> builder, State properties) throws IOException {
        super(builder, properties);
        Preconditions.checkArgument((boolean)this.properties.contains("writer.output.format.class"));
        this.writer = this.getWriter();
    }

    private FileSinkOperator.RecordWriter getWriter() throws IOException {
        try {
            HiveOutputFormat outputFormat = (HiveOutputFormat)HiveOutputFormat.class.cast(Class.forName(this.properties.getProp("writer.output.format.class")).newInstance());
            Class<?> writableClass = Class.forName(this.properties.getProp("writer.writable.class"));
            JobConf loadedJobConf = new JobConf();
            for (Object key : this.properties.getProperties().keySet()) {
                loadedJobConf.set((String)key, this.properties.getProp((String)key));
            }
            return outputFormat.getHiveRecordWriter(loadedJobConf, this.stagingFile, writableClass, true, this.properties.getProperties(), null);
        }
        catch (Throwable t) {
            throw new IOException(String.format("Failed to create writer", new Object[0]), t);
        }
    }

    public void write(Writable record) throws IOException {
        Preconditions.checkNotNull((Object)record);
        this.writer.write(record);
        this.count.incrementAndGet();
    }

    public long recordsWritten() {
        return this.count.get();
    }

    @Override
    public long bytesWritten() throws IOException {
        if (!this.fs.exists(this.outputFile)) {
            return 0L;
        }
        return this.fs.getFileStatus(this.outputFile).getLen();
    }

    @Override
    public void close() throws IOException {
        this.closeInternal();
        super.close();
    }

    @Override
    public void commit() throws IOException {
        this.closeInternal();
        super.commit();
    }

    private void closeInternal() throws IOException {
        if (!this.closed) {
            this.writer.close(false);
            this.writer = null;
            this.closed = true;
        }
    }

    @Override
    public boolean isSpeculativeAttemptSafe() {
        return this.writerAttemptIdOptional.isPresent() && this.getClass() == HiveWritableHdfsDataWriter.class;
    }
}

