/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.http;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import org.apache.gobblin.converter.http.RestEntry;
import org.apache.gobblin.writer.http.AbstractHttpWriterBuilder;
import org.apache.gobblin.writer.http.HttpWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class RestJsonWriter
extends HttpWriter<RestEntry<JsonObject>> {
    public RestJsonWriter(AbstractHttpWriterBuilder builder) {
        super(builder);
    }

    @Override
    public Optional<HttpUriRequest> onNewRecord(RestEntry<JsonObject> record) {
        HttpUriRequest uriRequest = RequestBuilder.post().addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).setUri(this.combineUrl(this.getCurServerHost(), record.getResourcePath())).setEntity((HttpEntity)new StringEntity(record.getRestEntryVal().toString(), ContentType.APPLICATION_JSON)).build();
        return Optional.of((Object)uriRequest);
    }
}

