/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.partitioner;

import com.google.common.base.Optional;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.writer.partitioner.TimeBasedWriterPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedAvroWriterPartitioner
extends TimeBasedWriterPartitioner<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(TimeBasedAvroWriterPartitioner.class);
    public static final String WRITER_PARTITION_COLUMNS = "writer.partition.columns";
    public static final String WRITER_PARTITION_ENABLE_PARSE_AS_STRING = "writer.partition.enableParseAsString";
    private final Optional<List<String>> partitionColumns;
    private final boolean enableParseAsString;

    public TimeBasedAvroWriterPartitioner(State state) {
        this(state, 1, 0);
    }

    public TimeBasedAvroWriterPartitioner(State state, int numBranches, int branchId) {
        super(state, numBranches, branchId);
        this.partitionColumns = TimeBasedAvroWriterPartitioner.getWriterPartitionColumns(state, numBranches, branchId);
        this.enableParseAsString = TimeBasedAvroWriterPartitioner.getEnableParseAsString(state, numBranches, branchId);
        log.info("Enable parse as string: {}", (Object)this.enableParseAsString);
    }

    private static Optional<List<String>> getWriterPartitionColumns(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_COLUMNS, (int)numBranches, (int)branchId);
        log.info("Partition columns for dataset {} are: {}", (Object)state.getProp("dataset.urn"), (Object)state.getProp(propName));
        return state.contains(propName) ? Optional.of((Object)state.getPropAsList(propName)) : Optional.absent();
    }

    private static boolean getEnableParseAsString(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_ENABLE_PARSE_AS_STRING, (int)numBranches, (int)branchId);
        return state.getPropAsBoolean(propName, false);
    }

    @Override
    public long getRecordTimestamp(GenericRecord record) {
        return this.getRecordTimestamp(this.getWriterPartitionColumnValue(record));
    }

    @Override
    private long getRecordTimestamp(Optional<Object> writerPartitionColumnValue) {
        if (writerPartitionColumnValue.isPresent()) {
            Object val = writerPartitionColumnValue.get();
            if (val instanceof Long) {
                return (Long)val;
            }
            if (this.enableParseAsString) {
                return Long.parseLong(val.toString());
            }
        }
        return this.timeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    private Optional<Object> getWriterPartitionColumnValue(GenericRecord record) {
        if (!this.partitionColumns.isPresent()) {
            return Optional.absent();
        }
        for (String partitionColumn : (List)this.partitionColumns.get()) {
            Optional fieldValue = AvroUtils.getFieldValue((GenericRecord)record, (String)partitionColumn);
            if (!fieldValue.isPresent()) continue;
            return fieldValue;
        }
        return Optional.absent();
    }
}

